/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeResolver {
    private static final Type[] EMPTY_TYPES = new Type[0];
    private static Map<Class<?>, Map<TypeVariable<?>, Type>> typeMaps = new ConcurrentHashMap();

    private TypeResolver() {
    }

    public static Class<?> resolvePropertyType(Class<?> targetClass, Method readMethod, Method writeMethod) {
        Class<?> type = null;
        if (readMethod != null) {
            type = TypeResolver.resolveReturnType(targetClass, readMethod);
        }
        if (type == null && writeMethod != null) {
            type = TypeResolver.resolveParameterType(targetClass, writeMethod);
        }
        return type;
    }

    private static Class<?> resolveReturnType(Class<?> targetClass, Method method) {
        Type type = method.getGenericReturnType();
        return TypeResolver.resolveType(targetClass, type);
    }

    private static Class<?> resolveParameterType(Class<?> targetClass, Method method) {
        Type[] types = method.getGenericParameterTypes();
        if (types == null || types.length < 1) {
            return null;
        }
        return TypeResolver.resolveType(targetClass, types[0]);
    }

    private static Class<?> resolveType(Class<?> targetClass, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (!(type instanceof TypeVariable)) {
            return null;
        }
        Type targetType = null;
        Map<TypeVariable<?>, Type> typeMap = TypeResolver.getTypeMap(targetClass);
        for (Map.Entry<TypeVariable<?>, Type> typeVariableEntry : typeMap.entrySet()) {
            TypeVariable<?> typeVariable = typeVariableEntry.getKey();
            if (!typeVariable.getName().equals(((TypeVariable)type).getName())) continue;
            targetType = typeVariableEntry.getValue();
            break;
        }
        if (targetType instanceof Class) {
            return (Class)targetType;
        }
        return null;
    }

    private static Map<TypeVariable<?>, Type> getTypeMap(Class<?> targetClass) {
        if (typeMaps.containsKey(targetClass)) {
            return typeMaps.get(targetClass);
        }
        HashMap map = new HashMap();
        Class<?> clazz = targetClass;
        while (!Object.class.equals(clazz)) {
            Type genericSuperClass = clazz.getGenericSuperclass();
            if (genericSuperClass instanceof ParameterizedType) {
                TypeResolver.collectActualTypeArguments((ParameterizedType)genericSuperClass, map);
            }
            TypeResolver.collectActualTypeArguments(clazz.getGenericInterfaces(), map);
            clazz = clazz.getSuperclass();
        }
        typeMaps.put(targetClass, map);
        return map;
    }

    private static void collectActualTypeArguments(Type[] genericInterfaces, Map<TypeVariable<?>, Type> map) {
        for (Type genericInterface : genericInterfaces) {
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                TypeResolver.collectActualTypeArguments(parameterizedType, map);
                Type rawType = parameterizedType.getRawType();
                TypeResolver.collectActualTypeArguments(TypeResolver.getGenericInterfaces(rawType), map);
                continue;
            }
            TypeResolver.collectActualTypeArguments(TypeResolver.getGenericInterfaces(genericInterface), map);
        }
    }

    private static Type[] getGenericInterfaces(Type type) {
        if (type instanceof Class) {
            return ((Class)Class.class.cast(type)).getGenericInterfaces();
        }
        return EMPTY_TYPES;
    }

    private static void collectActualTypeArguments(ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> map) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            return;
        }
        TypeVariable<Class<T>>[] variables = ((Class)rawType).getTypeParameters();
        Type[] types = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < variables.length; ++i) {
            if (!(types[i] instanceof Class)) continue;
            map.put(variables[i], types[i]);
        }
    }
}

