/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DurationRoutePolicy.class);
    private CamelContext camelContext;
    private String routeId;
    private ScheduledExecutorService executorService;
    private volatile ScheduledFuture task;
    private final AtomicInteger doneMessages = new AtomicInteger();
    private final AtomicBoolean actionDone = new AtomicBoolean();
    private Action action = Action.STOP_ROUTE;
    private int maxMessages;
    private int maxSeconds;

    public DurationRoutePolicy() {
    }

    public DurationRoutePolicy(CamelContext camelContext, String routeId) {
        this.camelContext = camelContext;
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMaxSeconds() {
        return this.maxSeconds;
    }

    public void setMaxSeconds(int maxSeconds) {
        this.maxSeconds = maxSeconds;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void onInit(Route route) {
        super.onInit(route);
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)((Object)this));
        if (this.maxMessages == 0 && this.maxSeconds == 0) {
            throw new IllegalArgumentException("The options maxMessages or maxSeconds must be configured");
        }
        if (this.routeId == null) {
            this.routeId = route.getId();
        }
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "DurationRoutePolicy[" + this.routeId + "]");
        }
        if (this.maxSeconds > 0) {
            this.task = this.performMaxDurationAction();
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        int newDoneMessages = this.doneMessages.incrementAndGet();
        if (this.maxMessages > 0 && newDoneMessages >= this.maxMessages && this.actionDone.compareAndSet(false, true)) {
            this.performMaxMessagesAction();
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(false);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(false);
        }
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.executorService);
            this.executorService = null;
        }
    }

    protected void performMaxMessagesAction() {
        this.executorService.submit(this.createTask(true));
    }

    protected ScheduledFuture performMaxDurationAction() {
        return this.executorService.schedule(this.createTask(false), (long)this.maxSeconds, TimeUnit.SECONDS);
    }

    private Runnable createTask(boolean maxMessagesHit) {
        return () -> {
            try {
                String tail = maxMessagesHit ? " due max messages " + this.getMaxMessages() + " processed" : " due max seconds " + this.getMaxSeconds();
                if (this.action == Action.STOP_CAMEL_CONTEXT) {
                    LOG.info("Stopping CamelContext {}", (Object)tail);
                    this.camelContext.stop();
                } else if (this.action == Action.STOP_ROUTE) {
                    LOG.info("Stopping route: {}{}", (Object)this.routeId, (Object)tail);
                    this.camelContext.getRouteController().stopRoute(this.routeId);
                } else if (this.action == Action.SUSPEND_ROUTE) {
                    LOG.info("Suspending route: {}{}", (Object)this.routeId, (Object)tail);
                    this.camelContext.getRouteController().suspendRoute(this.routeId);
                } else if (this.action == Action.SUSPEND_ALL_ROUTES) {
                    LOG.info("Suspending all routes {}", (Object)tail);
                    this.camelContext.suspend();
                }
            }
            catch (Throwable e) {
                LOG.warn("Error performing action: {}", (Object)this.action, (Object)e);
            }
        };
    }

    static enum Action {
        STOP_CAMEL_CONTEXT,
        STOP_ROUTE,
        SUSPEND_ROUTE,
        SUSPEND_ALL_ROUTES;

    }
}

