/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core;

import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.CustomFieldMapper;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperModelContext;
import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.MappingProcessor;
import com.github.dozermapper.core.builder.DestBeanBuilderCreator;
import com.github.dozermapper.core.cache.CacheManager;
import com.github.dozermapper.core.classmap.ClassMappings;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.classmap.generator.BeanMappingGenerator;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.events.DefaultEventManager;
import com.github.dozermapper.core.events.EventListener;
import com.github.dozermapper.core.events.EventManager;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.metadata.DozerMappingMetadata;
import com.github.dozermapper.core.metadata.MappingMetadata;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DozerBeanMapper
implements Mapper,
MapperModelContext {
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final DestBeanBuilderCreator destBeanBuilderCreator;
    private final BeanMappingGenerator beanMappingGenerator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private final ClassMappings customMappings;
    private final Configuration globalConfiguration;
    private final List<String> mappingFiles;
    private final List<CustomConverter> customConverters;
    private final List<EventListener> eventListeners;
    private final Map<String, CustomConverter> customConvertersWithId;
    private CustomFieldMapper customFieldMapper;
    private final CacheManager cacheManager;
    private EventManager eventManager;

    DozerBeanMapper(List<String> mappingFiles, BeanContainer beanContainer, DestBeanCreator destBeanCreator, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, List<CustomConverter> customConverters, List<MappingFileData> mappingsFileData, List<EventListener> eventListeners, CustomFieldMapper customFieldMapper, Map<String, CustomConverter> customConvertersWithId, ClassMappings customMappings, Configuration globalConfiguration, CacheManager cacheManager) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.destBeanBuilderCreator = destBeanBuilderCreator;
        this.beanMappingGenerator = beanMappingGenerator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
        this.customConverters = new ArrayList<CustomConverter>(customConverters);
        this.eventListeners = new ArrayList<EventListener>(eventListeners);
        this.mappingFiles = new ArrayList<String>(mappingFiles);
        this.customFieldMapper = customFieldMapper;
        this.customConvertersWithId = new HashMap<String, CustomConverter>(customConvertersWithId);
        this.eventManager = new DefaultEventManager(eventListeners);
        this.customMappings = customMappings;
        this.globalConfiguration = globalConfiguration;
        this.cacheManager = cacheManager;
    }

    @Override
    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    @Override
    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return this.getMappingProcessor().map(source, destinationClass);
    }

    @Override
    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    protected Mapper getMappingProcessor() {
        MappingProcessor processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, this.customConverters, this.eventManager, this.customFieldMapper, this.customConvertersWithId, this.beanContainer, this.destBeanCreator, this.destBeanBuilderCreator, this.beanMappingGenerator, this.propertyDescriptorFactory);
        return processor;
    }

    @Override
    public MappingMetadata getMappingMetadata() {
        return new DozerMappingMetadata(this.customMappings);
    }

    @Override
    public MapperModelContext getMapperModelContext() {
        return this;
    }

    @Override
    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(this.mappingFiles);
    }

    @Override
    public List<CustomConverter> getCustomConverters() {
        return Collections.unmodifiableList(this.customConverters);
    }

    @Override
    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return Collections.unmodifiableMap(this.customConvertersWithId);
    }

    @Override
    public List<? extends EventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    @Override
    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }
}

