/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Objects;
import oadd.org.apache.calcite.avatica.org.apache.http.HttpHost;
import oadd.org.apache.calcite.avatica.org.apache.http.auth.AuthSchemeProvider;
import oadd.org.apache.calcite.avatica.org.apache.http.auth.AuthScope;
import oadd.org.apache.calcite.avatica.org.apache.http.auth.Credentials;
import oadd.org.apache.calcite.avatica.org.apache.http.auth.KerberosCredentials;
import oadd.org.apache.calcite.avatica.org.apache.http.client.methods.CloseableHttpResponse;
import oadd.org.apache.calcite.avatica.org.apache.http.client.methods.HttpPost;
import oadd.org.apache.calcite.avatica.org.apache.http.client.methods.HttpUriRequest;
import oadd.org.apache.calcite.avatica.org.apache.http.client.protocol.HttpClientContext;
import oadd.org.apache.calcite.avatica.org.apache.http.config.Lookup;
import oadd.org.apache.calcite.avatica.org.apache.http.config.RegistryBuilder;
import oadd.org.apache.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import oadd.org.apache.calcite.avatica.org.apache.http.entity.ContentType;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.auth.SPNegoSchemeFactory;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.client.BasicAuthCache;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.client.BasicCredentialsProvider;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.client.CloseableHttpClient;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.client.HttpClients;
import oadd.org.apache.calcite.avatica.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import oadd.org.apache.calcite.avatica.org.apache.http.util.EntityUtils;
import oadd.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientSpnegoImpl
implements AvaticaHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientSpnegoImpl.class);
    public static final String CACHED_CONNECTIONS_MAX_KEY = "avatica.http.spnego.max_cached";
    public static final String CACHED_CONNECTIONS_MAX_DEFAULT = "100";
    public static final String CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY = "avatica.http.spnego.max_per_route";
    public static final String CACHED_CONNECTIONS_MAX_PER_ROUTE_DEFAULT = "25";
    private static final boolean USE_CANONICAL_HOSTNAME = true;
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;
    final URL url;
    final HttpHost host;
    final PoolingHttpClientConnectionManager pool;
    final Lookup<AuthSchemeProvider> authRegistry;
    final BasicCredentialsProvider credentialsProvider;
    final BasicAuthCache authCache;
    final CloseableHttpClient client;

    public AvaticaCommonsHttpClientSpnegoImpl(URL url) {
        this(url, null);
    }

    public AvaticaCommonsHttpClientSpnegoImpl(URL url, GSSCredential credential) {
        this.url = Objects.requireNonNull(url);
        this.pool = new PoolingHttpClientConnectionManager();
        String maxCnxns = System.getProperty(CACHED_CONNECTIONS_MAX_KEY, CACHED_CONNECTIONS_MAX_DEFAULT);
        this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        String maxCnxnsPerRoute = System.getProperty(CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY, CACHED_CONNECTIONS_MAX_PER_ROUTE_DEFAULT);
        this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        this.host = new HttpHost(url.getHost(), url.getPort());
        this.authRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory(true, true)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            this.credentialsProvider.setCredentials(AuthScope.ANY, new KerberosCredentials(credential));
        } else {
            this.credentialsProvider.setCredentials(AuthScope.ANY, EmptyCredentials.INSTANCE);
        }
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setDefaultAuthSchemeRegistry(this.authRegistry).setConnectionManager(this.pool).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        HttpClientContext context = HttpClientContext.create();
        context.setTargetHost(this.host);
        context.setCredentialsProvider(this.credentialsProvider);
        context.setAuthSchemeRegistry(this.authRegistry);
        context.setAuthCache(this.authCache);
        ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
        HttpPost post = new HttpPost(AvaticaCommonsHttpClientSpnegoImpl.toURI(this.url));
        post.setEntity(entity);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, context);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                if (500 != statusCode) throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
            }
            byte[] byArray = EntityUtils.toByteArray(response.getEntity());
            return byArray;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Failed to execute HTTP request", e);
            throw new RuntimeException(e);
        }
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }
    }
}

