/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JsonAnyGetter;
import oadd.com.fasterxml.jackson.annotation.JsonAnySetter;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.com.fasterxml.jackson.databind.node.ObjectNode;
import oadd.org.apache.drill.common.exceptions.LogicalPlanParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicBean {
    static final Logger logger = LoggerFactory.getLogger(AbstractDynamicBean.class);
    private static volatile ObjectMapper MAPPER;
    private ObjectNode objectNode = new ObjectNode(null);

    @JsonAnySetter
    public void _anySetter(String name, JsonNode value) {
        this.objectNode.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, JsonNode> _anyGetter() {
        HashMap<String, JsonNode> unknowns = new HashMap<String, JsonNode>();
        Iterator<Map.Entry<String, JsonNode>> i = this.objectNode.fields();
        while (i.hasNext()) {
            Map.Entry<String, JsonNode> e = i.next();
            unknowns.put(e.getKey(), e.getValue());
        }
        return unknowns;
    }

    public <T> T getWith(Class<T> c) {
        try {
            return AbstractDynamicBean.getMapper().treeToValue(this.objectNode, c);
        }
        catch (JsonProcessingException e) {
            throw new LogicalPlanParsingException(String.format("Failure while trying to convert late bound json type to type of %s.", c.getCanonicalName()), e);
        }
    }

    private static synchronized ObjectMapper getMapper() {
        if (MAPPER == null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            MAPPER = mapper;
        }
        return MAPPER;
    }
}

