/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import oadd.com.fasterxml.jackson.annotation.JsonAutoDetect;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractPropertied;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.Propertied;
import oadd.org.apache.drill.exec.record.metadata.PropertyAccessor;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.parser.SchemaExprParser;
import oadd.org.joda.time.format.DateTimeFormatter;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"name", "type", "mode", "format", "default", "properties"})
public abstract class AbstractColumnMetadata
extends AbstractPropertied
implements ColumnMetadata {
    protected final String name;
    protected final TypeProtos.MinorType type;
    protected final TypeProtos.DataMode mode;
    protected final int precision;
    protected final int scale;

    @JsonCreator
    public static AbstractColumnMetadata createColumnMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="mode") TypeProtos.DataMode mode, @JsonProperty(value="properties") Map<String, String> properties) throws IOException {
        ColumnMetadata columnMetadata = SchemaExprParser.parseColumn(name, type, mode);
        columnMetadata.setProperties(properties);
        return (AbstractColumnMetadata)columnMetadata;
    }

    public AbstractColumnMetadata(MaterializedField schema) {
        this(schema.getName(), schema.getType());
    }

    public AbstractColumnMetadata(String name, TypeProtos.MajorType majorType) {
        this.name = name;
        this.type = majorType.getMinorType();
        this.mode = majorType.getMode();
        this.precision = majorType.hasPrecision() ? majorType.getPrecision() : -1;
        this.scale = majorType.hasScale() ? majorType.getScale() : -1;
    }

    public AbstractColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        this.name = name;
        this.type = type;
        this.mode = mode;
        this.precision = -1;
        this.scale = -1;
    }

    public AbstractColumnMetadata(AbstractColumnMetadata from) {
        super(from);
        this.name = from.name;
        this.type = from.type;
        this.mode = from.mode;
        this.precision = from.precision;
        this.scale = from.scale;
        this.setProperties(from.properties());
    }

    @Override
    public void bind(TupleMetadata parentTuple) {
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    public TypeProtos.MinorType type() {
        return this.type;
    }

    @Override
    public TypeProtos.MajorType majorType() {
        return TypeProtos.MajorType.newBuilder().setMinorType(this.type()).setMode(this.mode()).build();
    }

    @Override
    @JsonProperty(value="mode")
    public TypeProtos.DataMode mode() {
        return this.mode;
    }

    @Override
    public boolean isNullable() {
        return this.mode() == TypeProtos.DataMode.OPTIONAL;
    }

    @Override
    public boolean isArray() {
        return this.mode() == TypeProtos.DataMode.REPEATED;
    }

    @Override
    public int dimensions() {
        return this.isArray() ? 1 : 0;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isVariant() {
        return false;
    }

    @Override
    public boolean isMultiList() {
        return false;
    }

    @Override
    public boolean isDict() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return null;
    }

    @Override
    public VariantMetadata variantSchema() {
        return null;
    }

    @Override
    public ColumnMetadata childSchema() {
        return null;
    }

    @Override
    public boolean isVariableWidth() {
        return Types.isVarWidthType(this.type());
    }

    @Override
    public boolean isEquivalent(ColumnMetadata o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AbstractColumnMetadata other = (AbstractColumnMetadata)o;
        return this.name.equalsIgnoreCase(other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mode, other.mode);
    }

    public boolean equalsWithProperties(AbstractColumnMetadata other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.isEquivalent(other);
    }

    @Override
    public int expectedWidth() {
        return 0;
    }

    @Override
    public void setExpectedWidth(int width) {
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public void setExpectedElementCount(int childCount) {
        if (this.isArray()) {
            PropertyAccessor.set((Propertied)this, "drill.cardinality", Math.max(1, childCount));
        }
    }

    @Override
    public int expectedElementCount() {
        if (this.isArray()) {
            return PropertyAccessor.getInt(this, "drill.cardinality", 10);
        }
        return 1;
    }

    @Override
    public void setFormat(String value) {
        this.setProperty("drill.format", value);
    }

    @Override
    public String format() {
        return this.property("drill.format");
    }

    @Override
    public DateTimeFormatter dateTimeFormatter() {
        throw new UnsupportedOperationException("Date/time not supported for non-scalar columns");
    }

    @Override
    public void setDefaultValue(String value) {
        this.setProperty("drill.default", value);
    }

    @Override
    public String defaultValue() {
        return this.property("drill.default");
    }

    @Override
    public Object decodeDefaultValue() {
        return this.valueFromString(this.defaultValue());
    }

    @Override
    public Object valueFromString(String value) {
        throw new UnsupportedOperationException("Value conversion not supported for non-scalar columns");
    }

    @Override
    public String valueToString(Object value) {
        throw new UnsupportedOperationException("Value conversion not supported for non-scalar columns");
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, String> properties() {
        return super.properties();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(" ").append(this.schema().toString(false));
        this.appendContents(buf);
        if (this.hasProperties()) {
            buf.append(", properties: ").append(this.properties());
        }
        return buf.append("]").toString();
    }

    protected void appendContents(StringBuilder buf) {
    }

    @Override
    @JsonProperty(value="type")
    public abstract String typeString();

    @Override
    public String columnString() {
        StringBuilder builder = new StringBuilder();
        builder.append("`").append(this.escapeSpecialSymbols(this.name())).append("`");
        builder.append(" ");
        builder.append(this.typeString());
        if (!(this.isNullable() || this.isArray() || this.isMap() || this.isDict())) {
            builder.append(" NOT NULL");
        }
        if (this.hasProperties()) {
            if (this.format() != null) {
                builder.append(" FORMAT '").append(this.format()).append("'");
            }
            if (this.defaultValue() != null) {
                builder.append(" DEFAULT '").append(this.defaultValue()).append("'");
            }
            HashMap<String, String> copy = new HashMap<String, String>(this.properties());
            copy.remove("drill.format");
            copy.remove("drill.default");
            if (!copy.isEmpty()) {
                builder.append(" PROPERTIES { ");
                builder.append(copy.entrySet().stream().map(e -> String.format("'%s' = '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
                builder.append(" }");
            }
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Use isEquivalent() instead.");
    }

    public boolean equalsWithProperties(Object o) {
        if (!this.equals(o)) {
            return false;
        }
        return super.equals(o);
    }

    protected String escapeSpecialSymbols(String value) {
        return value.replaceAll("(\\\\)|(`)", "\\\\$0");
    }
}

