/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import oadd.io.netty.handler.ssl.SslContext;
import oadd.io.netty.handler.ssl.SslContextBuilder;
import oadd.io.netty.handler.ssl.SslProvider;
import oadd.org.apache.drill.common.exceptions.DrillException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ssl.SSLConfig;
import oadd.org.apache.drill.exec.ssl.SSLCredentialsProvider;
import oadd.org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfigClient
extends SSLConfig {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfigClient.class);
    private final Properties properties;
    private final Configuration hadoopConfig;
    private final boolean userSslEnabled;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean disableHostVerification;
    private final boolean disableCertificateVerification;
    private final boolean useSystemTrustStore;
    private final String protocol;
    private final int handshakeTimeout;
    private final String provider;
    private final String emptyString = "";

    public SSLConfigClient(Properties properties, Configuration hadoopConfig) throws DrillException {
        this.properties = properties;
        this.hadoopConfig = hadoopConfig;
        this.userSslEnabled = this.getBooleanProperty("enableTLS");
        SSLCredentialsProvider credentialsProvider = SSLCredentialsProvider.getSSLCredentialsProvider(this::getStringProperty, this::getPasswordStringProperty, this.getMode(), this.getBooleanProperty("useMapRSSLConfig"));
        this.trustStoreType = credentialsProvider.getTrustStoreType("trustStoreType", "JKS");
        this.trustStorePath = credentialsProvider.getTrustStoreLocation("trustStorePath", "");
        this.trustStorePassword = credentialsProvider.getTrustStorePassword("trustStorePassword", this.resolveHadoopPropertyName("ssl.{0}.truststore.password", this.getMode()));
        this.disableHostVerification = this.getBooleanProperty("disableHostVerification");
        this.disableCertificateVerification = this.getBooleanProperty("disableCertificateVerification");
        this.useSystemTrustStore = this.getBooleanProperty("useSystemTrustStore");
        this.protocol = this.getStringProperty("TLSProtocol", "TLSv1.2");
        int hsTimeout = this.getIntProperty("TLSHandshakeTimeout", 10000);
        if (hsTimeout <= 0) {
            hsTimeout = 10000;
        }
        this.handshakeTimeout = hsTimeout;
        this.provider = this.getStringProperty("TLSProvider", "JDK");
    }

    private boolean getBooleanProperty(String propName) {
        return this.properties != null && this.properties.containsKey(propName) && this.properties.getProperty(propName).compareToIgnoreCase("true") == 0;
    }

    private String getStringProperty(String name, String defaultValue) {
        String value = "";
        if (this.properties != null && this.properties.containsKey(name)) {
            value = this.properties.getProperty(name);
        }
        if (value.isEmpty()) {
            value = defaultValue;
        }
        value = value.trim();
        return value;
    }

    private String getPasswordStringProperty(String name, String hadoopName) {
        String value = this.getPassword(hadoopName);
        if (value == null) {
            value = this.getStringProperty(name, "");
        }
        return value;
    }

    private int getIntProperty(String name, int defaultValue) {
        String property;
        int value = defaultValue;
        if (this.properties != null && (property = this.properties.getProperty(name)) != null && property.length() > 0) {
            value = Integer.decode(property);
        }
        return value;
    }

    @Override
    public void validateKeyStore() throws DrillException {
    }

    @Override
    public SslContext initNettySslContext() throws DrillException {
        SslContext sslCtx;
        if (!this.userSslEnabled) {
            return null;
        }
        try {
            TrustManagerFactory tmf = this.initializeTrustManagerFactory();
            sslCtx = SslContextBuilder.forClient().sslProvider(this.getProvider()).trustManager(tmf).protocols(this.protocol).build();
        }
        catch (Exception e) {
            throw new DrillException("SSL is enabled but cannot be initialized due to the following exception: " + "[ " + e.getMessage() + "]. ");
        }
        this.nettySslContext = sslCtx;
        return sslCtx;
    }

    @Override
    public SSLContext initJDKSSLContext() throws DrillException {
        SSLContext sslCtx;
        if (!this.userSslEnabled) {
            return null;
        }
        try {
            TrustManagerFactory tmf = this.initializeTrustManagerFactory();
            sslCtx = SSLContext.getInstance(this.protocol);
            sslCtx.init(null, tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new DrillException("SSL is enabled but cannot be initialized due to the following exception: " + "[ " + e.getMessage() + "]. ");
        }
        this.jdkSSlContext = sslCtx;
        return sslCtx;
    }

    @Override
    public SSLEngine createSSLEngine(BufferAllocator allocator, String peerHost, int peerPort) {
        SSLEngine engine = super.createSSLEngine(allocator, peerHost, peerPort);
        if (!this.disableHostVerification()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        engine.setUseClientMode(true);
        try {
            engine.setEnableSessionCreation(true);
        }
        catch (Exception e) {
            logger.debug("Session creation not enabled. Exception: {}", (Object)e.getMessage());
        }
        return engine;
    }

    @Override
    public boolean isUserSslEnabled() {
        return this.userSslEnabled;
    }

    @Override
    public boolean isHttpsEnabled() {
        return false;
    }

    @Override
    public String getKeyStoreType() {
        return "";
    }

    @Override
    public String getKeyStorePath() {
        return "";
    }

    @Override
    public String getKeyStorePassword() {
        return "";
    }

    @Override
    public String getKeyPassword() {
        return "";
    }

    @Override
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public boolean hasTrustStorePath() {
        return !this.trustStorePath.isEmpty();
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    public boolean hasTrustStorePassword() {
        return !this.trustStorePassword.isEmpty();
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public SslProvider getProvider() {
        return this.provider.equalsIgnoreCase("JDK") ? SslProvider.JDK : SslProvider.OPENSSL;
    }

    @Override
    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @Override
    public SSLConfig.Mode getMode() {
        return SSLConfig.Mode.CLIENT;
    }

    @Override
    public boolean disableHostVerification() {
        return this.disableHostVerification;
    }

    @Override
    public boolean disableCertificateVerification() {
        return this.disableCertificateVerification;
    }

    @Override
    public boolean useSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    @Override
    public boolean isSslValid() {
        return true;
    }

    @Override
    Configuration getHadoopConfig() {
        return this.hadoopConfig;
    }
}

