/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.IntervalReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalVector.class);
    public static final int VALUE_WIDTH = 16;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 16;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 16 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new IntervalReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(65536, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public IntervalVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 16;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 16;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 16L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 16);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        int currentCapacity = this.data.capacity();
        for (newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L; newAllocationSize < (long)currentCapacity; newAllocationSize *= 2L) {
        }
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
        this.data.setZero(currentCapacity, this.data.capacity() - currentCapacity);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return newBuf;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.field, (Object)metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 16;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalVector)to);
    }

    public void transferTo(IntervalVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalVector target) {
        int startPoint = startIndex * 16;
        int sliceLength = length * 16;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 16;
    }

    @Override
    public int getValueWidth() {
        return 16;
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalVector from) {
        from.data.getBytes(fromIndex * 16, this.data, thisIndex * 16, 16);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (IntervalVector)from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableIntervalVector dest = (NullableIntervalVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            IntervalVector.this.data.setBytes(index * 16, value, 0, 16);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            IntervalVector.this.data.setBytes(index * 16, value, 0, 16);
        }

        public void set(int index, int months, int days, int milliseconds) {
            int offsetIndex = index * 16;
            IntervalVector.this.data.setInt(offsetIndex, months);
            IntervalVector.this.data.setInt(offsetIndex + 4, days);
            IntervalVector.this.data.setInt(offsetIndex + 8, milliseconds);
        }

        public void setSafe(int index, int months, int days, int milliseconds) {
            while (index >= IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            this.set(index, months, days, milliseconds);
        }

        protected void set(int index, IntervalHolder holder) {
            this.set(index, holder.months, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, IntervalHolder holder) {
            this.setSafe(index, holder.months, holder.days, holder.milliseconds);
        }

        protected void set(int index, NullableIntervalHolder holder) {
            this.set(index, holder.months, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, NullableIntervalHolder holder) {
            this.setSafe(index, holder.months, holder.days, holder.milliseconds);
        }

        @Override
        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = IntervalVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 16; ++w) {
                    IntervalVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalVector.this.getValueCapacity();
            int idx = 16 * valueCount;
            while (valueCount > IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalVector.this.incrementAllocationMonitor();
            } else if (IntervalVector.this.allocationMonitor > 0) {
                IntervalVector.this.allocationMonitor = 0;
            }
            IntervalVector.this.data.writerIndex(idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return IntervalVector.this.data.writerIndex() / 16;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return IntervalVector.this.data.slice(index * 16, 16);
        }

        public void get(int index, IntervalHolder holder) {
            int offsetIndex = index * 16;
            holder.months = IntervalVector.this.data.getInt(offsetIndex);
            holder.days = IntervalVector.this.data.getInt(offsetIndex + 4);
            holder.milliseconds = IntervalVector.this.data.getInt(offsetIndex + 8);
        }

        public void get(int index, NullableIntervalHolder holder) {
            int offsetIndex = index * 16;
            holder.isSet = 1;
            holder.months = IntervalVector.this.data.getInt(offsetIndex);
            holder.days = IntervalVector.this.data.getInt(offsetIndex + 4);
            holder.milliseconds = IntervalVector.this.data.getInt(offsetIndex + 8);
        }

        @Override
        public Period getObject(int index) {
            int offsetIndex = index * 16;
            int months = IntervalVector.this.data.getInt(offsetIndex);
            int days = IntervalVector.this.data.getInt(offsetIndex + 4);
            int millis = IntervalVector.this.data.getInt(offsetIndex + 8);
            return DateUtilities.fromInterval(months, days, millis);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int offsetIndex = index * 16;
            int months = IntervalVector.this.data.getInt(offsetIndex);
            int days = IntervalVector.this.data.getInt(offsetIndex + 4);
            int millis = IntervalVector.this.data.getInt(offsetIndex + 8);
            return DateUtilities.intervalStringBuilder(months, days, millis);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new IntervalVector(field, allocator);
        }

        public TransferImpl(IntervalVector to) {
            this.to = to;
        }

        @Override
        public IntervalVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalVector.this);
        }
    }
}

