/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.sql.Date;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.NullableDateVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import oadd.org.joda.time.DateTimeZone;
import oadd.org.joda.time.LocalDate;

public class NullableDateAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.DATE);
    private final NullableDateVector.Accessor ac;

    public NullableDateAccessor(NullableDateVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getDate(index);
    }

    @Override
    public Date getDate(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDate date = new LocalDate(this.ac.get(index), DateTimeZone.UTC);
        return new Date(date.toDate().getTime());
    }
}

