/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessorUtils;
import oadd.org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public class ColumnReaderFactory {
    private static final int typeCount = TypeProtos.MinorType.values().length;
    private static final Class<? extends BaseScalarReader>[] requiredReaders = new Class[typeCount];

    public static BaseScalarReader buildColumnReader(VectorAccessor va) {
        TypeProtos.MajorType major = va.type();
        TypeProtos.MinorType type = major.getMinorType();
        switch (type) {
            case GENERIC_OBJECT: 
            case LATE: 
            case NULL: 
            case LIST: 
            case MAP: 
            case DICT: {
                throw new UnsupportedOperationException(type.toString());
            }
        }
        return ColumnReaderFactory.newAccessor(type, requiredReaders);
    }

    public static <T> T newAccessor(TypeProtos.MinorType type, Class<? extends T>[] accessors) {
        try {
            Class<T> accessorClass = accessors[type.ordinal()];
            if (accessorClass == null) {
                throw new UnsupportedOperationException(type.toString());
            }
            return accessorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ColumnAccessorUtils.defineRequiredReaders(requiredReaders);
    }
}

