/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.function.BiFunction;
import java.util.function.Function;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionReader;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionVectorWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BitWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.DateWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal18Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal28SparseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal38SparseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal9Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.Float4Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.Float8Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.IntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalYearWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.SmallIntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TinyIntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.UInt2Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.UInt4Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.UInt8Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;

public class MapUtility {
    private static final String TYPE_MISMATCH_ERROR = "%s does not support heterogeneous value types. All values in the input map must be of the same type. The field [%s] has a differing type [%s].";

    public static void writeToMapFromReader(FieldReader fieldReader, BaseWriter.MapWriter mapWriter, String caller) {
        MapUtility.writeToMapFromReader(fieldReader, mapWriter, "value", caller);
    }

    public static void writeToMapFromReader(FieldReader fieldReader, BaseWriter.MapWriter mapWriter, String fieldName, String caller) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            WriterExtractor extractor = new WriterExtractor(fieldName, valueMajorType, mapWriter, fieldReader instanceof UnionReader);
            switch (valueMinorType) {
                case TINYINT: {
                    fieldReader.copyAsValue((TinyIntWriter)extractor.get(BaseWriter.ListWriter::tinyInt, BaseWriter.MapWriter::tinyInt, UnionVectorWriter::tinyInt));
                    break;
                }
                case SMALLINT: {
                    fieldReader.copyAsValue((SmallIntWriter)extractor.get(BaseWriter.ListWriter::smallInt, BaseWriter.MapWriter::smallInt, UnionVectorWriter::smallInt));
                    break;
                }
                case BIGINT: {
                    fieldReader.copyAsValue((BigIntWriter)extractor.get(BaseWriter.ListWriter::bigInt, BaseWriter.MapWriter::bigInt, UnionVectorWriter::bigInt));
                    break;
                }
                case INT: {
                    fieldReader.copyAsValue((IntWriter)extractor.get(BaseWriter.ListWriter::integer, BaseWriter.MapWriter::integer, UnionVectorWriter::integer));
                    break;
                }
                case UINT1: {
                    fieldReader.copyAsValue((UInt1Writer)extractor.get(BaseWriter.ListWriter::uInt1, BaseWriter.MapWriter::uInt1, UnionVectorWriter::uInt1));
                    break;
                }
                case UINT2: {
                    fieldReader.copyAsValue((UInt2Writer)extractor.get(BaseWriter.ListWriter::uInt2, BaseWriter.MapWriter::uInt2, UnionVectorWriter::uInt2));
                    break;
                }
                case UINT4: {
                    fieldReader.copyAsValue((UInt4Writer)extractor.get(BaseWriter.ListWriter::uInt4, BaseWriter.MapWriter::uInt4, UnionVectorWriter::uInt4));
                    break;
                }
                case UINT8: {
                    fieldReader.copyAsValue((UInt8Writer)extractor.get(BaseWriter.ListWriter::uInt8, BaseWriter.MapWriter::uInt8, UnionVectorWriter::uInt8));
                    break;
                }
                case DECIMAL9: {
                    fieldReader.copyAsValue((Decimal9Writer)extractor.get(BaseWriter.ListWriter::decimal9, BaseWriter.MapWriter::decimal9, rec$ -> ((UnionVectorWriter)rec$).decimal9()));
                    break;
                }
                case DECIMAL18: {
                    fieldReader.copyAsValue((Decimal18Writer)extractor.get(BaseWriter.ListWriter::decimal18, BaseWriter.MapWriter::decimal18, rec$ -> ((UnionVectorWriter)rec$).decimal18()));
                    break;
                }
                case DECIMAL28SPARSE: {
                    fieldReader.copyAsValue((Decimal28SparseWriter)extractor.get(BaseWriter.ListWriter::decimal28Sparse, BaseWriter.MapWriter::decimal28Sparse, rec$ -> ((UnionVectorWriter)rec$).decimal28Sparse()));
                    break;
                }
                case DECIMAL38SPARSE: {
                    fieldReader.copyAsValue((Decimal38SparseWriter)extractor.get(BaseWriter.ListWriter::decimal38Sparse, BaseWriter.MapWriter::decimal38Sparse, rec$ -> ((UnionVectorWriter)rec$).decimal38Sparse()));
                    break;
                }
                case VARDECIMAL: {
                    fieldReader.copyAsValue((VarDecimalWriter)extractor.get(lw -> lw.varDecimal(valueMajorType.getPrecision(), valueMajorType.getScale()), (mw, fn) -> mw.varDecimal((String)fn, valueMajorType.getPrecision(), valueMajorType.getScale()), uw -> uw.varDecimal(valueMajorType.getPrecision(), valueMajorType.getScale())));
                    break;
                }
                case DATE: {
                    fieldReader.copyAsValue((DateWriter)extractor.get(BaseWriter.ListWriter::date, BaseWriter.MapWriter::date, UnionVectorWriter::date));
                    break;
                }
                case TIME: {
                    fieldReader.copyAsValue((TimeWriter)extractor.get(BaseWriter.ListWriter::time, BaseWriter.MapWriter::time, UnionVectorWriter::time));
                    break;
                }
                case TIMESTAMP: {
                    fieldReader.copyAsValue((TimeStampWriter)extractor.get(BaseWriter.ListWriter::timeStamp, BaseWriter.MapWriter::timeStamp, UnionVectorWriter::timeStamp));
                    break;
                }
                case INTERVAL: {
                    fieldReader.copyAsValue((IntervalWriter)extractor.get(BaseWriter.ListWriter::interval, BaseWriter.MapWriter::interval, UnionVectorWriter::interval));
                    break;
                }
                case INTERVALDAY: {
                    fieldReader.copyAsValue((IntervalDayWriter)extractor.get(BaseWriter.ListWriter::intervalDay, BaseWriter.MapWriter::intervalDay, UnionVectorWriter::intervalDay));
                    break;
                }
                case INTERVALYEAR: {
                    fieldReader.copyAsValue((IntervalYearWriter)extractor.get(BaseWriter.ListWriter::intervalYear, BaseWriter.MapWriter::intervalYear, UnionVectorWriter::intervalYear));
                    break;
                }
                case FLOAT4: {
                    fieldReader.copyAsValue((Float4Writer)extractor.get(BaseWriter.ListWriter::float4, BaseWriter.MapWriter::float4, UnionVectorWriter::float4));
                    break;
                }
                case FLOAT8: {
                    fieldReader.copyAsValue((Float8Writer)extractor.get(BaseWriter.ListWriter::float8, BaseWriter.MapWriter::float8, UnionVectorWriter::float8));
                    break;
                }
                case BIT: {
                    fieldReader.copyAsValue((BitWriter)extractor.get(BaseWriter.ListWriter::bit, BaseWriter.MapWriter::bit, UnionVectorWriter::bit));
                    break;
                }
                case VARCHAR: {
                    fieldReader.copyAsValue((VarCharWriter)extractor.get(BaseWriter.ListWriter::varChar, BaseWriter.MapWriter::varChar, UnionVectorWriter::varChar));
                    break;
                }
                case VARBINARY: {
                    fieldReader.copyAsValue((VarBinaryWriter)extractor.get(BaseWriter.ListWriter::varBinary, BaseWriter.MapWriter::varBinary, UnionVectorWriter::varBinary));
                    break;
                }
                case MAP: {
                    fieldReader.copyAsValue((BaseWriter.MapWriter)extractor.get(BaseWriter.ListWriter::map, BaseWriter.MapWriter::map, UnionVectorWriter::map));
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(mapWriter.list(fieldName).list());
                    break;
                }
                case DICT: {
                    fieldReader.copyAsValue((BaseWriter.DictWriter)extractor.get(BaseWriter.ListWriter::dict, BaseWriter.MapWriter::dict, UnionVectorWriter::dict));
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format("%s does not support input of type: %s", caller, valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(TYPE_MISMATCH_ERROR, caller, field.getName(), field.getType()));
        }
    }

    public static void writeToListFromReader(FieldReader fieldReader, BaseWriter.ListWriter listWriter, String caller) {
        try {
            TypeProtos.MajorType valueMajorType = fieldReader.getType();
            TypeProtos.MinorType valueMinorType = valueMajorType.getMinorType();
            switch (valueMinorType) {
                case TINYINT: {
                    fieldReader.copyAsValue(listWriter.tinyInt());
                    break;
                }
                case SMALLINT: {
                    fieldReader.copyAsValue(listWriter.smallInt());
                    break;
                }
                case BIGINT: {
                    fieldReader.copyAsValue(listWriter.bigInt());
                    break;
                }
                case INT: {
                    fieldReader.copyAsValue(listWriter.integer());
                    break;
                }
                case UINT1: {
                    fieldReader.copyAsValue(listWriter.uInt1());
                    break;
                }
                case UINT2: {
                    fieldReader.copyAsValue(listWriter.uInt2());
                    break;
                }
                case UINT4: {
                    fieldReader.copyAsValue(listWriter.uInt4());
                    break;
                }
                case UINT8: {
                    fieldReader.copyAsValue(listWriter.uInt8());
                    break;
                }
                case DECIMAL9: {
                    fieldReader.copyAsValue(listWriter.decimal9());
                    break;
                }
                case DECIMAL18: {
                    fieldReader.copyAsValue(listWriter.decimal18());
                    break;
                }
                case DECIMAL28SPARSE: {
                    fieldReader.copyAsValue(listWriter.decimal28Sparse());
                    break;
                }
                case DECIMAL38SPARSE: {
                    fieldReader.copyAsValue(listWriter.decimal38Sparse());
                    break;
                }
                case VARDECIMAL: {
                    fieldReader.copyAsValue(listWriter.varDecimal(valueMajorType.getPrecision(), valueMajorType.getScale()));
                    break;
                }
                case DATE: {
                    fieldReader.copyAsValue(listWriter.date());
                    break;
                }
                case TIME: {
                    fieldReader.copyAsValue(listWriter.time());
                    break;
                }
                case TIMESTAMP: {
                    fieldReader.copyAsValue(listWriter.timeStamp());
                    break;
                }
                case INTERVAL: {
                    fieldReader.copyAsValue(listWriter.interval());
                    break;
                }
                case INTERVALDAY: {
                    fieldReader.copyAsValue(listWriter.intervalDay());
                    break;
                }
                case INTERVALYEAR: {
                    fieldReader.copyAsValue(listWriter.intervalYear());
                    break;
                }
                case FLOAT4: {
                    fieldReader.copyAsValue(listWriter.float4());
                    break;
                }
                case FLOAT8: {
                    fieldReader.copyAsValue(listWriter.float8());
                    break;
                }
                case BIT: {
                    fieldReader.copyAsValue(listWriter.bit());
                    break;
                }
                case VARCHAR: {
                    fieldReader.copyAsValue(listWriter.varChar());
                    break;
                }
                case VARBINARY: {
                    fieldReader.copyAsValue(listWriter.varBinary());
                    break;
                }
                case MAP: {
                    fieldReader.copyAsValue(listWriter.map());
                    break;
                }
                case LIST: {
                    fieldReader.copyAsValue(listWriter.list());
                    break;
                }
                default: {
                    throw new DrillRuntimeException(String.format(caller + " function does not support input of type: %s", valueMinorType));
                }
            }
        }
        catch (ClassCastException e) {
            MaterializedField field = fieldReader.getField();
            throw new DrillRuntimeException(String.format(caller + TYPE_MISMATCH_ERROR, field.getName(), field.getType()));
        }
    }

    private static class WriterExtractor {
        private final String fieldName;
        private final boolean repeated;
        private final BaseWriter.MapWriter mapWriter;
        private final boolean isUnionField;

        private WriterExtractor(String fieldName, TypeProtos.MajorType majorType, BaseWriter.MapWriter mapWriter, boolean isUnionField) {
            this.fieldName = fieldName;
            this.repeated = majorType.getMode() == TypeProtos.DataMode.REPEATED;
            this.mapWriter = mapWriter;
            this.isUnionField = isUnionField;
        }

        private <W> W get(Function<BaseWriter.ListWriter, W> listFunc, BiFunction<BaseWriter.MapWriter, String, W> mapFunc, Function<UnionVectorWriter, W> unionFunc) {
            if (this.repeated) {
                BaseWriter.ListWriter listWriter = this.mapWriter.list(this.fieldName);
                if (this.isUnionField) {
                    return unionFunc.apply(listWriter.union());
                }
                return listFunc.apply(listWriter);
            }
            if (this.isUnionField) {
                return unionFunc.apply(this.mapWriter.union(this.fieldName));
            }
            return mapFunc.apply(this.mapWriter, this.fieldName);
        }
    }
}

