/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.viewfs;

import java.net.URI;
import java.util.Arrays;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.util.StringUtils;

public class ConfigUtil {
    public static String getConfigViewFsPrefix(String mountTableName) {
        return "fs.viewfs.mounttable." + mountTableName;
    }

    public static String getConfigViewFsPrefix() {
        return ConfigUtil.getConfigViewFsPrefix("fs.viewfs.mounttable.default");
    }

    public static void addLink(Configuration conf, String mountTableName, String src, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "link" + "." + src, target.toString());
    }

    public static void addLink(Configuration conf, String src, URI target) {
        ConfigUtil.addLink(conf, "default", src, target);
    }

    public static void addLinkMergeSlash(Configuration conf, String mountTableName, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "linkMergeSlash", target.toString());
    }

    public static void addLinkMergeSlash(Configuration conf, URI target) {
        ConfigUtil.addLinkMergeSlash(conf, "default", target);
    }

    public static void addLinkFallback(Configuration conf, String mountTableName, URI target) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "linkFallback", target.toString());
    }

    public static void addLinkFallback(Configuration conf, URI target) {
        ConfigUtil.addLinkFallback(conf, "default", target);
    }

    public static void addLinkMerge(Configuration conf, String mountTableName, URI[] targets) {
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "linkMerge", Arrays.toString(targets));
    }

    public static void addLinkMerge(Configuration conf, URI[] targets) {
        ConfigUtil.addLinkMerge(conf, "default", targets);
    }

    public static void addLinkNfly(Configuration conf, String mountTableName, String src, String settings, URI ... targets) {
        settings = settings == null ? "minReplication=2,repairOnRead=true" : settings;
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "linkNfly" + "." + settings + "." + src, StringUtils.uriToString(targets));
    }

    public static void addLinkNfly(Configuration conf, String src, URI ... targets) {
        ConfigUtil.addLinkNfly(conf, "default", src, null, targets);
    }

    public static void setHomeDirConf(Configuration conf, String homedir) {
        ConfigUtil.setHomeDirConf(conf, "default", homedir);
    }

    public static void setHomeDirConf(Configuration conf, String mountTableName, String homedir) {
        if (!homedir.startsWith("/")) {
            throw new IllegalArgumentException("Home dir should start with /:" + homedir);
        }
        conf.set(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "homedir", homedir);
    }

    public static String getHomeDirValue(Configuration conf) {
        return ConfigUtil.getHomeDirValue(conf, "default");
    }

    public static String getHomeDirValue(Configuration conf, String mountTableName) {
        return conf.get(ConfigUtil.getConfigViewFsPrefix(mountTableName) + "." + "homedir");
    }
}

