/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.AbstractNativeRawEncoder;

@InterfaceAudience.Private
public class NativeXORRawEncoder
extends AbstractNativeRawEncoder {
    public NativeXORRawEncoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
        this.encoderLock.writeLock().lock();
        try {
            this.initImpl(coderOptions.getNumDataUnits(), coderOptions.getNumParityUnits());
        }
        finally {
            this.encoderLock.writeLock().unlock();
        }
    }

    @Override
    protected void performEncodeImpl(ByteBuffer[] inputs, int[] inputOffsets, int dataLen, ByteBuffer[] outputs, int[] outputOffsets) throws IOException {
        this.encodeImpl(inputs, inputOffsets, dataLen, outputs, outputOffsets);
    }

    @Override
    public void release() {
        this.encoderLock.writeLock().lock();
        try {
            this.destroyImpl();
        }
        finally {
            this.encoderLock.writeLock().unlock();
        }
    }

    private native void initImpl(int var1, int var2);

    private native void encodeImpl(ByteBuffer[] var1, int[] var2, int var3, ByteBuffer[] var4, int[] var5) throws IOException;

    private native void destroyImpl();

    static {
        ErasureCodeNative.checkNativeCodeLoaded();
    }
}

