/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import oadd.org.apache.zookeeper.common.FileKeyStoreLoader;

abstract class StandardTypeFileKeyStoreLoader
extends FileKeyStoreLoader {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    StandardTypeFileKeyStoreLoader(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
    }

    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        try (FileInputStream inputStream = new FileInputStream(new File(this.keyStorePath));){
            KeyStore ks = this.keyStoreInstance();
            ks.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.keyStorePassword));
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        try (FileInputStream inputStream = new FileInputStream(new File(this.trustStorePath));){
            KeyStore ts = this.keyStoreInstance();
            ts.load(inputStream, StandardTypeFileKeyStoreLoader.passwordStringToCharArray(this.trustStorePassword));
            KeyStore keyStore = ts;
            return keyStore;
        }
    }

    protected abstract KeyStore keyStoreInstance() throws KeyStoreException;

    private static char[] passwordStringToCharArray(String password) {
        return password == null ? EMPTY_CHAR_ARRAY : password.toCharArray();
    }
}

