/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.MultiResponse;
import oadd.org.apache.zookeeper.OpResult;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.common.Time;
import oadd.org.apache.zookeeper.data.ACL;
import oadd.org.apache.zookeeper.data.Id;
import oadd.org.apache.zookeeper.data.Stat;
import oadd.org.apache.zookeeper.proto.CheckWatchesRequest;
import oadd.org.apache.zookeeper.proto.Create2Response;
import oadd.org.apache.zookeeper.proto.CreateResponse;
import oadd.org.apache.zookeeper.proto.ExistsRequest;
import oadd.org.apache.zookeeper.proto.ExistsResponse;
import oadd.org.apache.zookeeper.proto.GetACLRequest;
import oadd.org.apache.zookeeper.proto.GetACLResponse;
import oadd.org.apache.zookeeper.proto.GetChildren2Request;
import oadd.org.apache.zookeeper.proto.GetChildren2Response;
import oadd.org.apache.zookeeper.proto.GetChildrenRequest;
import oadd.org.apache.zookeeper.proto.GetChildrenResponse;
import oadd.org.apache.zookeeper.proto.GetDataRequest;
import oadd.org.apache.zookeeper.proto.GetDataResponse;
import oadd.org.apache.zookeeper.proto.RemoveWatchesRequest;
import oadd.org.apache.zookeeper.proto.ReplyHeader;
import oadd.org.apache.zookeeper.proto.SetACLResponse;
import oadd.org.apache.zookeeper.proto.SetDataResponse;
import oadd.org.apache.zookeeper.proto.SetWatches;
import oadd.org.apache.zookeeper.proto.SyncRequest;
import oadd.org.apache.zookeeper.proto.SyncResponse;
import oadd.org.apache.zookeeper.server.ByteBufferInputStream;
import oadd.org.apache.zookeeper.server.DataNode;
import oadd.org.apache.zookeeper.server.DataTree;
import oadd.org.apache.zookeeper.server.PrepRequestProcessor;
import oadd.org.apache.zookeeper.server.Request;
import oadd.org.apache.zookeeper.server.RequestProcessor;
import oadd.org.apache.zookeeper.server.ServerCnxn;
import oadd.org.apache.zookeeper.server.ServerCnxnFactory;
import oadd.org.apache.zookeeper.server.ZooKeeperServer;
import oadd.org.apache.zookeeper.server.ZooTrace;
import oadd.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import oadd.org.apache.zookeeper.txn.ErrorTxn;
import oadd.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FinalRequestProcessor.class);
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing request:: " + request);
        }
        long traceMask = 2L;
        if (request.type == 11) {
            traceMask = 128L;
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        }
        DataTree.ProcessTxnResult rc = null;
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            rc = this.zks.processTxn(request);
            if (request.getHdr() != null) {
                TxnHeader hdr = request.getHdr();
                Record txn = request.getTxn();
                long zxid = hdr.getZxid();
                while (!this.zks.outstandingChanges.isEmpty() && this.zks.outstandingChanges.peek().zxid <= zxid) {
                    ZooKeeperServer.ChangeRecord cr = this.zks.outstandingChanges.remove();
                    if (cr.zxid < zxid) {
                        LOG.warn("Zxid outstanding " + cr.zxid + " is less than current " + zxid);
                    }
                    if (this.zks.outstandingChangesForPath.get(cr.path) != cr) continue;
                    this.zks.outstandingChangesForPath.remove(cr.path);
                }
            }
            if (request.isQuorum()) {
                this.zks.getZKDatabase().addCommittedProposal(request);
            }
        }
        if (request.type == -11 && this.connClosedByClient(request) && (this.closeSession(this.zks.serverCnxnFactory, request.sessionId) || this.closeSession(this.zks.secureServerCnxnFactory, request.sessionId))) {
            return;
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn cnxn = request.cnxn;
        String lastOp = "NA";
        this.zks.decInProcess();
        KeeperException.Code err = KeeperException.Code.OK;
        Record rsp = null;
        try {
            if (request.getHdr() != null && request.getHdr().getType() == -1) {
                if (request.getException() != null) {
                    throw request.getException();
                }
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.getTxn()).getErr()));
            }
            KeeperException ke = request.getException();
            if (ke != null && request.type != 14) {
                throw ke;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", (Object)request);
            }
            switch (request.type) {
                case 11: {
                    this.zks.serverStats().updateLatency(request.createTime);
                    lastOp = "PING";
                    cnxn.updateStatsForResponse(request.cxid, request.zxid, lastOp, request.createTime, Time.currentElapsedTime());
                    cnxn.sendResponse(new ReplyHeader(-2, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), 0), null, "response");
                    return;
                }
                case -10: {
                    this.zks.serverStats().updateLatency(request.createTime);
                    lastOp = "SESS";
                    cnxn.updateStatsForResponse(request.cxid, request.zxid, lastOp, request.createTime, Time.currentElapsedTime());
                    this.zks.finishSessionInit(request.cnxn, true);
                    return;
                }
                case 14: {
                    lastOp = "MULT";
                    rsp = new MultiResponse();
                    for (DataTree.ProcessTxnResult subTxnResult : rc.multiResult) {
                        OpResult subResult;
                        switch (subTxnResult.type) {
                            case 13: {
                                subResult = new OpResult.CheckResult();
                                break;
                            }
                            case 1: {
                                subResult = new OpResult.CreateResult(subTxnResult.path);
                                break;
                            }
                            case 15: 
                            case 19: 
                            case 21: {
                                subResult = new OpResult.CreateResult(subTxnResult.path, subTxnResult.stat);
                                break;
                            }
                            case 2: 
                            case 20: {
                                subResult = new OpResult.DeleteResult();
                                break;
                            }
                            case 5: {
                                subResult = new OpResult.SetDataResult(subTxnResult.stat);
                                break;
                            }
                            case -1: {
                                subResult = new OpResult.ErrorResult(subTxnResult.err);
                                break;
                            }
                            default: {
                                throw new IOException("Invalid type of op");
                            }
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 1: {
                    lastOp = "CREA";
                    rsp = new CreateResponse(rc.path);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 15: 
                case 19: 
                case 21: {
                    lastOp = "CREA";
                    rsp = new Create2Response(rc.path, rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 2: 
                case 20: {
                    lastOp = "DELE";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 5: {
                    lastOp = "SETD";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 16: {
                    lastOp = "RECO";
                    rsp = new GetDataResponse(((QuorumZooKeeperServer)this.zks).self.getQuorumVerifier().toString().getBytes(), rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 7: {
                    lastOp = "SETA";
                    rsp = new SetACLResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case -11: {
                    lastOp = "CLOS";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 9: {
                    lastOp = "SYNC";
                    SyncRequest syncRequest = new SyncRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, syncRequest);
                    rsp = new SyncResponse(syncRequest.getPath());
                    break;
                }
                case 13: {
                    lastOp = "CHEC";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 3: {
                    lastOp = "EXIS";
                    ExistsRequest existsRequest = new ExistsRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, existsRequest);
                    String path = existsRequest.getPath();
                    if (path.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = this.zks.getZKDatabase().statNode(path, existsRequest.getWatch() ? cnxn : null);
                    rsp = new ExistsResponse(stat);
                    break;
                }
                case 4: {
                    lastOp = "GETD";
                    GetDataRequest getDataRequest = new GetDataRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getDataRequest);
                    DataNode n = this.zks.getZKDatabase().getNode(getDataRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo);
                    Stat stat = new Stat();
                    byte[] b = this.zks.getZKDatabase().getData(getDataRequest.getPath(), stat, getDataRequest.getWatch() ? cnxn : null);
                    rsp = new GetDataResponse(b, stat);
                    break;
                }
                case 101: {
                    lastOp = "SETW";
                    SetWatches setWatches = new SetWatches();
                    request.request.rewind();
                    ByteBufferInputStream.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = setWatches.getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, setWatches.getDataWatches(), setWatches.getExistWatches(), setWatches.getChildWatches(), cnxn);
                    break;
                }
                case 6: {
                    lastOp = "GETA";
                    GetACLRequest getACLRequest = new GetACLRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getACLRequest);
                    DataNode n = this.zks.getZKDatabase().getNode(getACLRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().aclForNode(n), 17, request.authInfo);
                    Stat stat = new Stat();
                    List<ACL> acl = this.zks.getZKDatabase().getACL(getACLRequest.getPath(), stat);
                    try {
                        PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().aclForNode(n), 16, request.authInfo);
                        rsp = new GetACLResponse(acl, stat);
                    }
                    catch (KeeperException.NoAuthException e) {
                        ArrayList<ACL> acl1 = new ArrayList<ACL>(acl.size());
                        for (ACL a : acl) {
                            if ("digest".equals(a.getId().getScheme())) {
                                Id id = a.getId();
                                Id id1 = new Id(id.getScheme(), id.getId().replaceAll(":.*", ":x"));
                                acl1.add(new ACL(a.getPerms(), id1));
                                continue;
                            }
                            acl1.add(a);
                        }
                        rsp = new GetACLResponse(acl1, stat);
                    }
                    break;
                }
                case 8: {
                    lastOp = "GETC";
                    GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildrenRequest);
                    DataNode n = this.zks.getZKDatabase().getNode(getChildrenRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo);
                    List<String> children = this.zks.getZKDatabase().getChildren(getChildrenRequest.getPath(), null, getChildrenRequest.getWatch() ? cnxn : null);
                    rsp = new GetChildrenResponse(children);
                    break;
                }
                case 12: {
                    lastOp = "GETC";
                    GetChildren2Request getChildren2Request = new GetChildren2Request();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildren2Request);
                    Stat stat = new Stat();
                    DataNode n = this.zks.getZKDatabase().getNode(getChildren2Request.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo);
                    List<String> children = this.zks.getZKDatabase().getChildren(getChildren2Request.getPath(), stat, getChildren2Request.getWatch() ? cnxn : null);
                    rsp = new GetChildren2Response(children, stat);
                    break;
                }
                case 17: {
                    lastOp = "CHKW";
                    CheckWatchesRequest checkWatches = new CheckWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkWatches);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(checkWatches.getType());
                    boolean containsWatcher = this.zks.getZKDatabase().containsWatcher(checkWatches.getPath(), type, cnxn);
                    if (containsWatcher) break;
                    String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{checkWatches.getPath(), type});
                    throw new KeeperException.NoWatcherException(msg);
                }
                case 18: {
                    lastOp = "REMW";
                    RemoveWatchesRequest removeWatches = new RemoveWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, removeWatches);
                    Watcher.WatcherType type = Watcher.WatcherType.fromInt(removeWatches.getType());
                    boolean removed = this.zks.getZKDatabase().removeWatch(removeWatches.getPath(), type, cnxn);
                    if (removed) break;
                    String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{removeWatches.getPath(), type});
                    throw new KeeperException.NoWatcherException(msg);
                }
            }
        }
        catch (KeeperException.SessionMovedException e) {
            cnxn.sendCloseSession();
            return;
        }
        catch (KeeperException e) {
            err = e.code();
        }
        catch (Exception e) {
            LOG.error("Failed to process " + request, e);
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = request.request;
            bb.rewind();
            while (bb.hasRemaining()) {
                sb.append(Integer.toHexString(bb.get() & 0xFF));
            }
            LOG.error("Dumping request buffer: 0x" + sb.toString());
            err = KeeperException.Code.MARSHALLINGERROR;
        }
        long lastZxid = this.zks.getZKDatabase().getDataTreeLastProcessedZxid();
        ReplyHeader hdr = new ReplyHeader(request.cxid, lastZxid, err.intValue());
        this.zks.serverStats().updateLatency(request.createTime);
        cnxn.updateStatsForResponse(request.cxid, lastZxid, lastOp, request.createTime, Time.currentElapsedTime());
        try {
            cnxn.sendResponse(hdr, rsp, "response");
            if (request.type == -11) {
                cnxn.sendCloseSession();
            }
        }
        catch (IOException e) {
            LOG.error("FIXMSG", e);
        }
    }

    private boolean closeSession(ServerCnxnFactory serverCnxnFactory, long sessionId) {
        if (serverCnxnFactory == null) {
            return false;
        }
        return serverCnxnFactory.closeSession(sessionId);
    }

    private boolean connClosedByClient(Request request) {
        return request.cnxn == null;
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown of request processor complete");
    }
}

