/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetColumnChunkPageWriteStore
implements PageWriteStore,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ParquetColumnChunkPageWriteStore.class);
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private final Map<ColumnDescriptor, ColumnChunkPageWriter> writers = new HashMap<ColumnDescriptor, ColumnChunkPageWriter>();
    private final MessageType schema;

    public ParquetColumnChunkPageWriteStore(CodecFactory.BytesCompressor compressor, MessageType schema, int initialSlabSize, int maxCapacityHint, ByteBufferAllocator allocator, boolean pageWriteChecksumEnabled, int columnIndexTruncateLength) {
        this.schema = schema;
        for (ColumnDescriptor path : schema.getColumns()) {
            this.writers.put(path, new ColumnChunkPageWriter(path, compressor, initialSlabSize, maxCapacityHint, allocator, pageWriteChecksumEnabled, columnIndexTruncateLength));
        }
    }

    public PageWriter getPageWriter(ColumnDescriptor path) {
        return this.writers.get(path);
    }

    public void flushToFileWriter(ParquetFileWriter writer) throws IOException {
        for (ColumnDescriptor path : this.schema.getColumns()) {
            ColumnChunkPageWriter pageWriter = this.writers.get(path);
            pageWriter.writeToFileWriter(writer);
        }
    }

    @Override
    public void close() {
        for (ColumnChunkPageWriter pageWriter : this.writers.values()) {
            pageWriter.close();
        }
    }

    private static final class ColumnChunkPageWriter
    implements PageWriter,
    Closeable {
        private final ColumnDescriptor path;
        private final CodecFactory.BytesCompressor compressor;
        private final CapacityByteArrayOutputStream buf;
        private DictionaryPage dictionaryPage;
        private long uncompressedLength;
        private long compressedLength;
        private long totalValueCount;
        private int pageCount;
        private Set<Encoding> rlEncodings = new HashSet<Encoding>();
        private Set<Encoding> dlEncodings = new HashSet<Encoding>();
        private List<Encoding> dataEncodings = new ArrayList<Encoding>();
        private ColumnIndexBuilder columnIndexBuilder;
        private OffsetIndexBuilder offsetIndexBuilder;
        private Statistics totalStatistics;
        private final CRC32 crc;
        boolean pageWriteChecksumEnabled;

        private ColumnChunkPageWriter(ColumnDescriptor path, CodecFactory.BytesCompressor compressor, int initialSlabSize, int maxCapacityHint, ByteBufferAllocator allocator, boolean pageWriteChecksumEnabled, int columnIndexTruncateLength) {
            this.path = path;
            this.compressor = compressor;
            this.buf = new CapacityByteArrayOutputStream(initialSlabSize, maxCapacityHint, allocator);
            this.totalStatistics = Statistics.createStats((Type)this.path.getPrimitiveType());
            this.columnIndexBuilder = ColumnIndexBuilder.getBuilder((PrimitiveType)path.getPrimitiveType(), (int)columnIndexTruncateLength);
            this.offsetIndexBuilder = OffsetIndexBuilder.getBuilder();
            this.pageWriteChecksumEnabled = pageWriteChecksumEnabled;
            this.crc = pageWriteChecksumEnabled ? new CRC32() : null;
        }

        public void writePage(BytesInput bytesInput, int valueCount, Statistics<?> statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
            this.columnIndexBuilder = ColumnIndexBuilder.getNoOpBuilder();
            this.offsetIndexBuilder = OffsetIndexBuilder.getNoOpBuilder();
            this.writePage(bytesInput, valueCount, -1, statistics, rlEncoding, dlEncoding, valuesEncoding);
        }

        public void writePage(BytesInput bytes, int valueCount, int rowCount, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
            long uncompressedSize = bytes.size();
            if (uncompressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than Integer.MAX_VALUE bytes: " + uncompressedSize);
            }
            BytesInput compressedBytes = this.compressor.compress(bytes);
            long compressedSize = compressedBytes.size();
            if (compressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write compressed page larger than Integer.MAX_VALUE bytes: " + compressedSize);
            }
            if (this.pageWriteChecksumEnabled) {
                this.crc.reset();
                this.crc.update(compressedBytes.toByteArray());
                parquetMetadataConverter.writeDataPageV1Header((int)uncompressedSize, (int)compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, (int)this.crc.getValue(), (OutputStream)this.buf);
            } else {
                parquetMetadataConverter.writeDataPageV1Header((int)uncompressedSize, (int)compressedSize, valueCount, rlEncoding, dlEncoding, valuesEncoding, (OutputStream)this.buf);
            }
            this.uncompressedLength += uncompressedSize;
            this.compressedLength += compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            this.addStatistics(statistics);
            this.offsetIndexBuilder.add(this.toIntWithCheck(this.buf.size() + compressedSize), (long)rowCount);
            compressedBytes.writeAllTo((OutputStream)this.buf);
            this.rlEncodings.add(rlEncoding);
            this.dlEncodings.add(dlEncoding);
            this.dataEncodings.add(valuesEncoding);
        }

        private void addStatistics(Statistics statistics) {
            if (this.totalStatistics == null) {
                this.totalStatistics = statistics.copy();
            } else {
                this.totalStatistics.mergeStatistics(statistics);
            }
            this.columnIndexBuilder.add(statistics);
        }

        public void writePageV2(int rowCount, int nullCount, int valueCount, BytesInput repetitionLevels, BytesInput definitionLevels, Encoding dataEncoding, BytesInput data, Statistics<?> statistics) throws IOException {
            int rlByteLength = this.toIntWithCheck(repetitionLevels.size());
            int dlByteLength = this.toIntWithCheck(definitionLevels.size());
            int uncompressedSize = this.toIntWithCheck(data.size() + repetitionLevels.size() + definitionLevels.size());
            BytesInput compressedData = this.compressor.compress(data);
            int compressedSize = this.toIntWithCheck(compressedData.size() + repetitionLevels.size() + definitionLevels.size());
            parquetMetadataConverter.writeDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, statistics, dataEncoding, rlByteLength, dlByteLength, (OutputStream)this.buf);
            this.uncompressedLength += (long)uncompressedSize;
            this.compressedLength += (long)compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            this.addStatistics(statistics);
            this.offsetIndexBuilder.add(this.toIntWithCheck(this.buf.size() + (long)compressedSize), (long)rowCount);
            repetitionLevels.writeAllTo((OutputStream)this.buf);
            definitionLevels.writeAllTo((OutputStream)this.buf);
            compressedData.writeAllTo((OutputStream)this.buf);
            this.dataEncodings.add(dataEncoding);
        }

        private int toIntWithCheck(long size) {
            if (size > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than 2147483647 bytes: " + size);
            }
            return (int)size;
        }

        public long getMemSize() {
            return this.buf.size();
        }

        public void writeToFileWriter(ParquetFileWriter writer) throws IOException {
            writer.writeColumnChunk(this.path, this.totalValueCount, this.compressor.getCodecName(), this.dictionaryPage, BytesInput.from((CapacityByteArrayOutputStream)this.buf), this.uncompressedLength, this.compressedLength, this.totalStatistics, this.columnIndexBuilder, this.offsetIndexBuilder, this.rlEncodings, this.dlEncodings, this.dataEncodings);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("written %,dB for %s: %,d values, %,dB raw, %,dB comp, %d pages, encodings: %s", this.buf.size(), this.path, this.totalValueCount, this.uncompressedLength, this.compressedLength, this.pageCount, new HashSet<Encoding>(this.dataEncodings)) + (this.dictionaryPage != null ? String.format(", dic { %,d entries, %,dB raw, %,dB comp}", this.dictionaryPage.getDictionarySize(), this.dictionaryPage.getUncompressedSize(), this.dictionaryPage.getDictionarySize()) : ""));
            }
            this.rlEncodings.clear();
            this.dlEncodings.clear();
            this.dataEncodings.clear();
            this.pageCount = 0;
        }

        public long allocatedSize() {
            return this.buf.getCapacity();
        }

        public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
            if (this.dictionaryPage != null) {
                throw new ParquetEncodingException("Only one dictionary page is allowed");
            }
            BytesInput dictionaryBytes = dictionaryPage.getBytes();
            int uncompressedSize = (int)dictionaryBytes.size();
            BytesInput compressedBytes = this.compressor.compress(dictionaryBytes);
            this.dictionaryPage = new DictionaryPage(BytesInput.copy((BytesInput)compressedBytes), uncompressedSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding());
        }

        public String memUsageString(String prefix) {
            return this.buf.memUsageString(prefix + " ColumnChunkPageWriter");
        }

        @Override
        public void close() {
            this.buf.close();
        }
    }
}

