/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import oadd.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import oadd.org.joda.time.Instant;

public class InstantDeserializer
extends JodaDateDeserializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public InstantDeserializer(JacksonJodaDateFormat format) {
        super(Instant.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new InstantDeserializer(format);
    }

    @Override
    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Instant(p.getLongValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            return Instant.parse(str, this._format.createParser(ctxt));
        }
        return (Instant)this._handleNotNumberOrString(p, ctxt);
    }
}

