/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import oadd.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import oadd.org.joda.time.YearMonth;

public class YearMonthDeserializer
extends JodaDateDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;

    public YearMonthDeserializer() {
        this(FormatConfig.DEFAULT_YEAR_MONTH_FORMAT);
    }

    public YearMonthDeserializer(JacksonJodaDateFormat format) {
        super(YearMonth.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new YearMonthDeserializer(format);
    }

    @Override
    public YearMonth deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.isEmpty()) {
                return null;
            }
            return YearMonth.parse(str, this._format.createParser(ctxt));
        }
        return (YearMonth)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected JSON String", new Object[0]);
    }
}

