/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.typesafe.config.impl;

import java.util.Collection;
import java.util.Collections;
import oadd.com.typesafe.config.ConfigException;
import oadd.com.typesafe.config.ConfigOrigin;
import oadd.com.typesafe.config.ConfigRenderOptions;
import oadd.com.typesafe.config.ConfigValueType;
import oadd.com.typesafe.config.impl.AbstractConfigValue;
import oadd.com.typesafe.config.impl.Path;
import oadd.com.typesafe.config.impl.ResolveContext;
import oadd.com.typesafe.config.impl.ResolveReplacer;
import oadd.com.typesafe.config.impl.ResolveStatus;
import oadd.com.typesafe.config.impl.SubstitutionExpression;
import oadd.com.typesafe.config.impl.Unmergeable;

final class ConfigReference
extends AbstractConfigValue
implements Unmergeable {
    private final SubstitutionExpression expr;
    private final int prefixLength;

    ConfigReference(ConfigOrigin configOrigin, SubstitutionExpression substitutionExpression) {
        this(configOrigin, substitutionExpression, 0);
    }

    private ConfigReference(ConfigOrigin configOrigin, SubstitutionExpression substitutionExpression, int n) {
        super(configOrigin);
        this.expr = substitutionExpression;
        this.prefixLength = n;
    }

    private ConfigException.NotResolved notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve(), see the API docs for Config#resolve(); substitution not resolved: " + this);
    }

    @Override
    public ConfigValueType valueType() {
        throw this.notResolved();
    }

    @Override
    public Object unwrapped() {
        throw this.notResolved();
    }

    @Override
    protected ConfigReference newCopy(ConfigOrigin configOrigin) {
        return new ConfigReference(configOrigin, this.expr, this.prefixLength);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return false;
    }

    public Collection<ConfigReference> unmergedValues() {
        return Collections.singleton(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext resolveContext) {
        resolveContext.source().replace(this, ResolveReplacer.cycleResolveReplacer);
        try {
            AbstractConfigValue abstractConfigValue;
            try {
                abstractConfigValue = resolveContext.source().lookupSubst(resolveContext, this.expr, this.prefixLength);
            }
            catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
                if (this.expr.optional()) {
                    abstractConfigValue = null;
                }
                throw new ConfigException.UnresolvedSubstitution(this.origin(), this.expr + " was part of a cycle of substitutions involving " + notPossibleToResolve.traceString(), notPossibleToResolve);
            }
            if (abstractConfigValue == null && !this.expr.optional()) {
                throw new ConfigException.UnresolvedSubstitution(this.origin(), this.expr.toString());
            }
            AbstractConfigValue abstractConfigValue2 = abstractConfigValue;
            return abstractConfigValue2;
        }
        finally {
            resolveContext.source().unreplace(this);
        }
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigReference relativized(Path path) {
        SubstitutionExpression substitutionExpression = this.expr.changePath(this.expr.path().prepend(path));
        return new ConfigReference(this.origin(), substitutionExpression, this.prefixLength + path.length());
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigReference;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigReference) {
            return this.canEqual(object) && this.expr.equals(((ConfigReference)object).expr);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.expr.hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        stringBuilder.append(this.expr.toString());
    }

    SubstitutionExpression expression() {
        return this.expr;
    }
}

