/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.handler.codec.protobuf;

import java.util.List;
import oadd.com.google.protobuf.CodedInputStream;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.ByteToMessageDecoder;
import oadd.io.netty.handler.codec.CorruptedFrameException;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance(buf, 0, i + 1).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            out.add(in.readSlice(length).retain());
            return;
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

