/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.details;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import oadd.org.apache.curator.shaded.com.google.common.collect.Lists;
import oadd.org.apache.curator.utils.CloseableExecutorService;
import oadd.org.apache.curator.x.discovery.DownInstancePolicy;
import oadd.org.apache.curator.x.discovery.InstanceFilter;
import oadd.org.apache.curator.x.discovery.ProviderStrategy;
import oadd.org.apache.curator.x.discovery.ServiceProvider;
import oadd.org.apache.curator.x.discovery.ServiceProviderBuilder;
import oadd.org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;
import oadd.org.apache.curator.x.discovery.details.ServiceProviderImpl;

class ServiceProviderBuilderImpl<T>
implements ServiceProviderBuilder<T> {
    private ServiceDiscoveryImpl<T> discovery;
    private String serviceName;
    private ProviderStrategy<T> providerStrategy;
    private ThreadFactory threadFactory;
    private CloseableExecutorService executorService;
    private List<InstanceFilter<T>> filters = Lists.newArrayList();
    private DownInstancePolicy downInstancePolicy = new DownInstancePolicy();

    @Override
    public ServiceProvider<T> build() {
        return new ServiceProviderImpl<T>(this.discovery, this.serviceName, this.providerStrategy, this.threadFactory, this.executorService, this.filters, this.downInstancePolicy);
    }

    ServiceProviderBuilderImpl(ServiceDiscoveryImpl<T> discovery) {
        this.discovery = discovery;
    }

    @Override
    public ServiceProviderBuilder<T> serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> providerStrategy(ProviderStrategy<T> providerStrategy) {
        this.providerStrategy = providerStrategy;
        return this;
    }

    @Override
    @Deprecated
    public ServiceProviderBuilder<T> threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.executorService = null;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> downInstancePolicy(DownInstancePolicy downInstancePolicy) {
        this.downInstancePolicy = downInstancePolicy;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> additionalFilter(InstanceFilter<T> filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> executorService(ExecutorService executorService) {
        return this.executorService(new CloseableExecutorService(executorService));
    }

    @Override
    public ServiceProviderBuilder<T> executorService(CloseableExecutorService executorService) {
        this.executorService = executorService;
        this.threadFactory = null;
        return this;
    }
}

