/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.List;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.FilterPredicate;
import oadd.org.apache.drill.exec.expr.StatisticsProvider;
import oadd.org.apache.drill.exec.expr.stat.RowsMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BooleanPredicate<C extends Comparable<C>>
extends BooleanOperator
implements FilterPredicate<C> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanPredicate.class);

    private BooleanPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        super(name, args, pos);
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitBooleanOperator(this, value);
    }

    private static <C extends Comparable<C>> LogicalExpression createAndPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new BooleanPredicate<C>(name, (List)args, pos){

            @Override
            public RowsMatch matches(StatisticsProvider<C> evaluator) {
                RowsMatch resultMatch = RowsMatch.ALL;
                for (LogicalExpression child : this) {
                    if (!(child instanceof FilterPredicate)) continue;
                    switch (((FilterPredicate)((Object)child)).matches(evaluator)) {
                        case NONE: {
                            return RowsMatch.NONE;
                        }
                        case SOME: {
                            resultMatch = RowsMatch.SOME;
                        }
                    }
                }
                return resultMatch;
            }
        };
    }

    private static <C extends Comparable<C>> LogicalExpression createOrPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        return new BooleanPredicate<C>(name, (List)args, pos){

            @Override
            public RowsMatch matches(StatisticsProvider<C> evaluator) {
                RowsMatch resultMatch = RowsMatch.NONE;
                for (LogicalExpression child : this) {
                    if (!(child instanceof FilterPredicate)) continue;
                    switch (((FilterPredicate)((Object)child)).matches(evaluator)) {
                        case ALL: {
                            return RowsMatch.ALL;
                        }
                        case SOME: {
                            resultMatch = RowsMatch.SOME;
                        }
                    }
                }
                return resultMatch;
            }
        };
    }

    public static <C extends Comparable<C>> LogicalExpression createBooleanPredicate(String function, String name, List<LogicalExpression> args, ExpressionPosition pos) {
        switch (function) {
            case "booleanOr": {
                return BooleanPredicate.createOrPredicate(name, args, pos);
            }
            case "booleanAnd": {
                return BooleanPredicate.createAndPredicate(name, args, pos);
            }
        }
        logger.warn("Unknown Boolean '{}' predicate.", (Object)function);
        return null;
    }
}

