/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;

public class HashVisitor
extends AbstractExprVisitor<Integer, Void, RuntimeException> {
    @Override
    public Integer visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        return this.compute(call, 1);
    }

    @Override
    public Integer visitFunctionHolderExpression(FunctionHolderExpression holder, Void value) throws RuntimeException {
        return this.compute(holder, 2);
    }

    @Override
    public Integer visitIfExpression(IfExpression ifExpr, Void value) throws RuntimeException {
        return this.compute(ifExpr, 3);
    }

    @Override
    public Integer visitBooleanOperator(BooleanOperator op, Void value) throws RuntimeException {
        return this.compute(op, 4);
    }

    @Override
    public Integer visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
        return this.compute(path, 5);
    }

    @Override
    public Integer visitFloatConstant(ValueExpressions.FloatExpression fExpr, Void value) throws RuntimeException {
        return this.compute(fExpr, 6);
    }

    @Override
    public Integer visitIntConstant(ValueExpressions.IntExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 7);
    }

    @Override
    public Integer visitLongConstant(ValueExpressions.LongExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 8);
    }

    @Override
    public Integer visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, Void value) throws RuntimeException {
        return this.compute(decExpr, 9);
    }

    @Override
    public Integer visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, Void value) throws RuntimeException {
        return this.compute(decExpr, 10);
    }

    @Override
    public Integer visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, Void value) throws RuntimeException {
        return this.compute(decExpr, 11);
    }

    @Override
    public Integer visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, Void value) throws RuntimeException {
        return this.compute(decExpr, 12);
    }

    @Override
    public Integer visitDateConstant(ValueExpressions.DateExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 13);
    }

    @Override
    public Integer visitTimeConstant(ValueExpressions.TimeExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 14);
    }

    @Override
    public Integer visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 15);
    }

    @Override
    public Integer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 16);
    }

    @Override
    public Integer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, Void value) throws RuntimeException {
        return this.compute(intExpr, 17);
    }

    @Override
    public Integer visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Void value) throws RuntimeException {
        return this.compute(dExpr, 18);
    }

    @Override
    public Integer visitBooleanConstant(ValueExpressions.BooleanExpression e, Void value) throws RuntimeException {
        return this.compute(e, 19);
    }

    @Override
    public Integer visitQuotedStringConstant(ValueExpressions.QuotedString e, Void value) throws RuntimeException {
        return this.compute(e, 20);
    }

    @Override
    public Integer visitCastExpression(CastExpression e, Void value) throws RuntimeException {
        return this.compute(e, 21);
    }

    @Override
    public Integer visitConvertExpression(ConvertExpression e, Void value) throws RuntimeException {
        return this.compute(e, 22);
    }

    @Override
    public Integer visitNullConstant(TypedNullConstant e, Void value) throws RuntimeException {
        return this.compute(e, 23);
    }

    @Override
    public Integer visitNullExpression(NullExpression e, Void value) throws RuntimeException {
        return this.compute(e, 24);
    }

    @Override
    public Integer visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return this.compute(e, 25);
    }

    @Override
    public Integer visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Void value) throws RuntimeException {
        return this.compute(decExpr, 26);
    }

    private int compute(LogicalExpression e, int seed) {
        int hash = seed;
        for (LogicalExpression child : e) {
            hash = hash * 31 + child.accept(this, null);
        }
        return hash;
    }
}

