/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.HyperVectorWrapper;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class ExpandableHyperContainer
extends VectorContainer {
    public ExpandableHyperContainer() {
    }

    public ExpandableHyperContainer(VectorAccessible batch) {
        this.build(batch);
    }

    private void build(VectorAccessible batch) {
        if (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            for (VectorWrapper w : batch) {
                ValueVector[] hyperVector = w.getValueVectors();
                this.add(hyperVector, true);
            }
        } else {
            for (VectorWrapper w : batch) {
                ValueVector[] hyperVector = new ValueVector[]{w.getValueVector()};
                this.add(hyperVector, true);
            }
        }
        this.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
    }

    public void addBatch(VectorAccessible batch) {
        if (this.wrappers.size() == 0) {
            this.build(batch);
            return;
        }
        if (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            int i = 0;
            for (VectorWrapper w : batch) {
                HyperVectorWrapper hyperVectorWrapper = (HyperVectorWrapper)this.wrappers.get(i++);
                hyperVectorWrapper.addVectors(w.getValueVectors());
            }
        } else {
            int i = 0;
            for (VectorWrapper w : batch) {
                HyperVectorWrapper hyperVectorWrapper = (HyperVectorWrapper)this.wrappers.get(i++);
                hyperVectorWrapper.addVector((ValueVector)w.getValueVector());
            }
        }
        this.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
    }
}

