/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import oadd.org.apache.drill.exec.record.metadata.Propertied;

public class AbstractPropertied
implements Propertied {
    private Map<String, String> properties;

    protected AbstractPropertied() {
    }

    protected AbstractPropertied(AbstractPropertied from) {
        this.setProperties(from.properties);
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties().putAll(properties);
        }
    }

    @Override
    public Map<String, String> properties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public String property(String key) {
        return this.property(key, null);
    }

    @Override
    public String property(String key, String defValue) {
        if (this.properties == null) {
            return defValue;
        }
        String value = this.properties.get(key);
        return value == null ? defValue : value;
    }

    @Override
    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties().put(key, value);
        } else if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    @Override
    public boolean booleanProperty(String key) {
        return this.booleanProperty(key, false);
    }

    @Override
    public boolean booleanProperty(String key, boolean defaultValue) {
        String value = this.property(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        if (value) {
            this.setProperty(key, Boolean.toString(value));
        } else {
            this.setProperty(key, null);
        }
    }

    @Override
    public int intProperty(String key) {
        return this.intProperty(key, 0);
    }

    @Override
    public int intProperty(String key, int defaultValue) {
        String value = this.property(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    @Override
    public void setIntProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    @Override
    public void removeProperty(String key) {
        this.setProperty(key, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        AbstractPropertied other = (AbstractPropertied)o;
        if (!this.hasProperties() && !other.hasProperties()) {
            return true;
        }
        if (!this.hasProperties() || !other.hasProperties()) {
            return false;
        }
        return Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        if (!this.hasProperties()) {
            return 0;
        }
        return this.properties.hashCode();
    }
}

