/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr;

public class NodeResources {
    private final int version;
    private final long memoryInBytes;
    private final int numVirtualCpu;

    public NodeResources(long memoryInBytes, int numVirtualCpu) {
        this.memoryInBytes = memoryInBytes;
        this.numVirtualCpu = numVirtualCpu;
        this.version = 1;
    }

    public NodeResources(long memoryInBytes, int numPhysicalCpu, int vFactor) {
        this(memoryInBytes, numPhysicalCpu * vFactor);
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public long getMemoryInMB() {
        return Math.round(this.memoryInBytes / 1024L / 1024L);
    }

    public long getMemoryInGB() {
        return Math.round(this.getMemoryInMB() / 1024L);
    }

    public int getNumVirtualCpu() {
        return this.numVirtualCpu;
    }

    public String toString() {
        return "{ Version: " + this.version + ", MemoryInBytes: " + this.memoryInBytes + ", VirtualCPU: " + this.numVirtualCpu + " }";
    }
}

