/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.sasl.SaslException;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.rpc.security.AuthStringUtil;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import oadd.org.apache.drill.exec.rpc.security.plain.PlainFactory;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticatorFactory;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorProviderImpl
implements AuthenticatorProvider {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticatorProviderImpl.class);
    private final Map<String, AuthenticatorFactory> authFactories = CaseInsensitiveMap.newHashMapWithExpectedSize(5);

    public AuthenticatorProviderImpl(DrillConfig config, ScanResult scan) throws DrillbitStartupException {
        if (!config.getBoolean("drill.exec.security.user.auth.enabled")) {
            return;
        }
        List<String> configuredFactories = Lists.newArrayList();
        if (config.hasPath("drill.exec.security.auth.mechanisms")) {
            configuredFactories = config.getStringList("drill.exec.security.auth.mechanisms");
        }
        Set<String> configuredFactoriesSet = AuthStringUtil.asSet(configuredFactories);
        if (config.hasPath("drill.exec.security.user.auth.impl")) {
            configuredFactoriesSet.add("PLAIN");
        }
        if (configuredFactoriesSet.isEmpty()) {
            return;
        }
        logger.debug("Configuring authenticator factories: {}", (Object)configuredFactories);
        if (configuredFactoriesSet.remove("PLAIN")) {
            UserAuthenticator userAuthenticator = UserAuthenticatorFactory.createAuthenticator(config, scan);
            PlainFactory factory = new PlainFactory(userAuthenticator);
            this.authFactories.put("PLAIN", factory);
            logger.trace("Plain mechanism enabled.");
        }
        if (!configuredFactoriesSet.isEmpty()) {
            Set<Class<AuthenticatorFactory>> factoryImpls = scan.getImplementations(AuthenticatorFactory.class);
            logger.debug("Found AuthenticatorFactory implementations: {}", (Object)factoryImpls);
            for (Class clazz : factoryImpls) {
                Constructor<?> validConstructor = null;
                for (Constructor<?> c : clazz.getConstructors()) {
                    Class<?>[] params = c.getParameterTypes();
                    if (params.length != 0) continue;
                    validConstructor = c;
                    break;
                }
                if (validConstructor == null) {
                    logger.warn("Skipping authentication factory class {}. It must implement at least one constructor with signature [{}()]", (Object)clazz.getCanonicalName(), (Object)clazz.getName());
                    continue;
                }
                try {
                    AuthenticatorFactory instance = (AuthenticatorFactory)validConstructor.newInstance(new Object[0]);
                    if (!configuredFactoriesSet.remove(instance.getSimpleName().toUpperCase())) continue;
                    this.authFactories.put(instance.getSimpleName(), instance);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new DrillbitStartupException(String.format("Failed to create authentication factory of type '%s'", clazz.getCanonicalName()), e);
                }
            }
        }
        if (this.authFactories.size() == 0) {
            throw new DrillbitStartupException("Authentication enabled, but no mechanism was configured correctly. Please check authentication configuration.");
        }
        logger.info("Configured authentication mechanisms: {}", (Object)this.authFactories.keySet());
    }

    @Override
    public AuthenticatorFactory getAuthenticatorFactory(String name) throws SaslException {
        AuthenticatorFactory mechanism = this.authFactories.get(name);
        if (mechanism == null) {
            throw new SaslException(String.format("Unknown mechanism: '%s' Configured mechanisms: %s", name, this.authFactories.keySet()));
        }
        return mechanism;
    }

    @Override
    public Set<String> getAllFactoryNames() {
        return this.authFactories.keySet();
    }

    @Override
    public boolean containsFactory(String name) {
        return this.authFactories.containsKey(name);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.authFactories.values());
        this.authFactories.clear();
    }
}

