/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.schema;

import java.util.ArrayList;
import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.schema.Field;
import oadd.org.apache.drill.exec.schema.RecordSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Predicate;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ListSchema
implements RecordSchema {
    private List<Field> fields = Lists.newArrayList();

    @Override
    public void addField(Field field) {
        if (field.getFieldType().getMode() == TypeProtos.DataMode.REPEATED || this.fields.isEmpty() || !this.isSingleTyped() || !Iterables.getOnlyElement(this.fields).equals(field.getFieldType())) {
            this.fields.add(field);
        }
    }

    @Override
    public Field getField(String fieldName, int index) {
        Field field = this.isSingleTyped() ? (Field)Iterables.getOnlyElement(this.fields, null) : (index < this.fields.size() ? this.fields.get(index) : null);
        return field;
    }

    @Override
    public void removeField(Field field, int index) {
        Preconditions.checkArgument(this.fields.size() > index);
        this.fields.remove(index);
    }

    @Override
    public Iterable<? extends Field> getFields() {
        return this.fields;
    }

    public boolean isSingleTyped() {
        return this.fields.size() <= 1;
    }

    @Override
    public String toSchemaString() {
        StringBuilder builder = new StringBuilder("List_fields:[");
        for (Field field : this.fields) {
            builder.append(field.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void resetMarkedFields() {
        for (Field field : this.fields) {
            field.setRead(false);
        }
    }

    @Override
    public Iterable<? extends Field> removeUnreadFields() {
        final ArrayList removedFields = Lists.newArrayList();
        Iterables.removeIf(this.fields, new Predicate<Field>(){

            @Override
            public boolean apply(Field field) {
                if (!field.isRead()) {
                    removedFields.add(field);
                    return true;
                }
                if (field.hasSchema()) {
                    Iterables.addAll(removedFields, field.getAssignedSchema().removeUnreadFields());
                }
                return false;
            }
        });
        return removedFields;
    }
}

