/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import oadd.io.protostuff.Schema;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.store.TransientStore;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfig;
import oadd.org.apache.drill.exec.proto.SchemaUserBitShared;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.store.sys.PersistentStore;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreConfig;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreProvider;

public class QueryProfileStoreContext {
    private static final String PROFILES = "profiles";
    private static final String RUNNING = "running";
    private final PersistentStore<UserBitShared.QueryProfile> completedProfiles;
    private final TransientStore<UserBitShared.QueryInfo> runningProfiles;
    private final PersistentStoreConfig<UserBitShared.QueryProfile> profileStoreConfig = PersistentStoreConfig.newProtoBuilder((Schema)SchemaUserBitShared.QueryProfile.WRITE, (Schema)SchemaUserBitShared.QueryProfile.MERGE).name("profiles").blob().build();

    public QueryProfileStoreContext(DrillConfig config, PersistentStoreProvider storeProvider, ClusterCoordinator coordinator) {
        try {
            this.completedProfiles = storeProvider.getOrCreateStore(this.profileStoreConfig);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(e);
        }
        this.runningProfiles = coordinator.getOrCreateTransientStore(TransientStoreConfig.newProtoBuilder(SchemaUserBitShared.QueryInfo.WRITE, SchemaUserBitShared.QueryInfo.MERGE).name(RUNNING).build());
    }

    public PersistentStoreConfig<UserBitShared.QueryProfile> getProfileStoreConfig() {
        return this.profileStoreConfig;
    }

    public PersistentStore<UserBitShared.QueryProfile> getCompletedProfileStore() {
        return this.completedProfiles;
    }

    public TransientStore<UserBitShared.QueryInfo> getRunningProfileStore() {
        return this.runningProfiles;
    }
}

