/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.dfs.FileSystemConfig;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceConfig;
import oadd.org.apache.drill.exec.store.easy.sequencefile.SequenceFileFormatConfig;
import oadd.org.apache.drill.exec.store.easy.text.TextFormatPlugin;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class StoragePluginTestUtils {
    public static final String CP_PLUGIN_NAME = "cp";
    public static final String DFS_PLUGIN_NAME = "dfs";
    public static final String TMP_SCHEMA = "tmp";
    public static final String ROOT_SCHEMA = "root";
    public static final String DFS_TMP_SCHEMA = "dfs.tmp";
    public static final String DFS_DEFAULT_SCHEMA = "dfs.default";
    public static final String DFS_ROOT_SCHEMA = "dfs.root";
    public static final String UNIT_TEST_PROP_PREFIX = "drillJDBCUnitTests";
    public static final String UNIT_TEST_DFS_TMP_PROP = "drillJDBCUnitTests.dfs.tmp";
    public static final String UNIT_TEST_DFS_DEFAULT_PROP = "drillJDBCUnitTests.dfs.default";
    public static final String UNIT_TEST_DFS_ROOT_PROP = "drillJDBCUnitTests.dfs.root";

    public static void updateSchemaLocation(String pluginName, StoragePluginRegistry pluginRegistry, File tmpDirPath, String ... schemas) throws StoragePluginRegistry.PluginException {
        FileSystemConfig pluginConfig = (FileSystemConfig)pluginRegistry.getStoredConfig(pluginName);
        HashMap<String, WorkspaceConfig> newWorkspaces = new HashMap<String, WorkspaceConfig>();
        Optional.ofNullable(pluginConfig.getWorkspaces()).ifPresent(newWorkspaces::putAll);
        if (schemas.length == 0) {
            schemas = new String[]{TMP_SCHEMA};
        }
        for (String schema : schemas) {
            WorkspaceConfig workspaceConfig = (WorkspaceConfig)newWorkspaces.get(schema);
            String inputFormat = workspaceConfig == null ? null : workspaceConfig.getDefaultInputFormat();
            WorkspaceConfig newWorkspaceConfig = new WorkspaceConfig(tmpDirPath.getAbsolutePath(), true, inputFormat, false);
            newWorkspaces.put(schema, newWorkspaceConfig);
        }
        FileSystemConfig newPluginConfig = new FileSystemConfig(pluginConfig.getConnection(), pluginConfig.getConfig(), newWorkspaces, pluginConfig.getFormats());
        newPluginConfig.setEnabled(Boolean.valueOf(pluginConfig.isEnabled()));
        pluginRegistry.put(pluginName, (StoragePluginConfig)newPluginConfig);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry) throws StoragePluginRegistry.PluginException {
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, CP_PLUGIN_NAME);
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, DFS_PLUGIN_NAME);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry, String storagePlugin) throws StoragePluginRegistry.PluginException {
        FileSystemConfig fileSystemConfig = (FileSystemConfig)pluginRegistry.getStoredConfig(storagePlugin);
        HashMap<String, Object> newFormats = new HashMap<String, Object>();
        Optional.ofNullable(fileSystemConfig.getFormats()).ifPresent(newFormats::putAll);
        newFormats.put("txt", new TextFormatPlugin.TextFormatConfig(ImmutableList.of("txt"), null, "\u0000", null, null, null, null, null));
        newFormats.put("ssv", new TextFormatPlugin.TextFormatConfig(ImmutableList.of("ssv"), null, " ", null, null, null, null, null));
        newFormats.put("psv", new TextFormatPlugin.TextFormatConfig(ImmutableList.of("tbl"), null, "|", null, null, null, null, null));
        SequenceFileFormatConfig seqConfig = new SequenceFileFormatConfig(ImmutableList.of("seq"));
        newFormats.put("sequencefile", seqConfig);
        newFormats.put("csvh-test", new TextFormatPlugin.TextFormatConfig(ImmutableList.of("csvh-test"), null, ",", null, null, null, Boolean.valueOf(true), Boolean.valueOf(true)));
        FileSystemConfig newFileSystemConfig = new FileSystemConfig(fileSystemConfig.getConnection(), fileSystemConfig.getConfig(), fileSystemConfig.getWorkspaces(), newFormats);
        newFileSystemConfig.setEnabled(Boolean.valueOf(fileSystemConfig.isEnabled()));
        pluginRegistry.put(storagePlugin, (StoragePluginConfig)newFileSystemConfig);
    }
}

