/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.Decimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal9Holder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.Decimal9Vector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDecimal9ReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal9Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Decimal9Vector values;
    private final FieldReader reader = new RepeatedDecimal9ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal9Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withPrecisionAndScale(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getPrecision(), majorType.getScale())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Decimal9Vector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedDecimal9Vector)to);
    }

    public AddOrGetResult<Decimal9Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<Decimal9Vector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedDecimal9Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedDecimal9Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m3 = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m3.set(i, normalizedPos);
        }
        m3.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedDecimal9Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedDecimal9Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedDecimal9Vector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedDecimal9Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, int srcValue) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedDecimal9Holder h2) {
            Decimal9Holder ih = new Decimal9Holder();
            Decimal9Vector.Accessor hVectorAccessor = h2.vector.getAccessor();
            RepeatedDecimal9Vector.this.mutator.startNewValue(index);
            for (int i = h2.start; i < h2.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedDecimal9Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Decimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableDecimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedDecimal9Vector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, Decimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedDecimal9Holder holder) {
            Decimal9Vector.Accessor accessor = holder.vector.getAccessor();
            Decimal9Holder innerHolder = new Decimal9Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedDecimal9Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedDecimal9Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedDecimal9Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Decimal9Vector.Accessor valuesAccessor = RepeatedDecimal9Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public BigDecimal getSingleObject(int index, int arrayIndex) {
            int start = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            return RepeatedDecimal9Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public int get(int index, int positionIndex) {
            return RepeatedDecimal9Vector.this.values.getAccessor().get(RepeatedDecimal9Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedDecimal9Holder holder) {
            holder.start = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedDecimal9Vector.this.values;
            holder.reader = RepeatedDecimal9Vector.this.reader;
        }

        public void get(int index, int positionIndex, Decimal9Holder holder) {
            int offset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedDecimal9Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableDecimal9Holder holder) {
            int offset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedDecimal9Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedDecimal9Vector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedDecimal9Vector(field, allocator);
        }

        public TransferImpl(RepeatedDecimal9Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedDecimal9Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedDecimal9Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedDecimal9Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedDecimal9Vector.this);
        }
    }
}

