/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import oadd.com.fasterxml.jackson.core.JsonParseException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.VarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.complex.fn.WorkingBuffer;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.DateWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TimeWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import oadd.org.joda.time.DateTime;
import oadd.org.joda.time.DateTimeZone;
import oadd.org.joda.time.Period;
import oadd.org.joda.time.format.ISOPeriodFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class VectorOutput {
    private static final Logger logger = LoggerFactory.getLogger(VectorOutput.class);
    final VarBinaryHolder binary = new VarBinaryHolder();
    final TimeHolder time = new TimeHolder();
    final DateHolder date = new DateHolder();
    final TimeStampHolder timestamp = new TimeStampHolder();
    final IntervalHolder interval = new IntervalHolder();
    final BigIntHolder bigint = new BigIntHolder();
    final Decimal38DenseHolder decimal = new Decimal38DenseHolder();
    final VarCharHolder varchar = new VarCharHolder();
    protected final WorkingBuffer work;
    protected JsonParser parser;

    public VectorOutput(WorkingBuffer work) {
        this.work = work;
    }

    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    protected boolean innerRun() throws IOException {
        JsonToken t = this.parser.nextToken();
        if (t != JsonToken.FIELD_NAME) {
            return false;
        }
        String possibleTypeName = this.parser.getText();
        if (!possibleTypeName.isEmpty() && possibleTypeName.charAt(0) == '$') {
            switch (possibleTypeName) {
                case "$binary": {
                    this.writeBinary(this.checkNextToken(JsonToken.VALUE_STRING));
                    this.checkCurrentToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$type": {
                    if (this.checkNextToken(JsonToken.VALUE_NUMBER_INT) || !this.hasBinary()) {
                        throw UserException.parseError().message("Either $type is not an integer or has no $binary", new Object[0]).build(logger);
                    }
                    this.writeBinary(this.checkNextToken(JsonToken.VALUE_STRING));
                    this.checkCurrentToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$dateDay": {
                    this.writeDate(this.checkNextToken(JsonToken.VALUE_STRING));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$time": {
                    this.writeTime(this.checkNextToken(JsonToken.VALUE_STRING));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$date": {
                    this.writeTimestamp(this.checkNextToken(JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$interval": {
                    this.writeInterval(this.checkNextToken(JsonToken.VALUE_STRING));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$numberLong": {
                    this.writeInteger(this.checkNextToken(JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
                case "$decimal": {
                    this.writeDecimal(this.checkNextToken(JsonToken.VALUE_NUMBER_FLOAT, JsonToken.VALUE_NUMBER_INT));
                    this.checkNextToken(JsonToken.END_OBJECT);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkNextToken(JsonToken expected) throws IOException {
        return this.checkNextToken(expected, expected);
    }

    public boolean checkCurrentToken(JsonToken expected) throws IOException {
        return this.checkCurrentToken(expected, expected);
    }

    public boolean checkNextToken(JsonToken expected1, JsonToken expected2) throws IOException {
        return this.checkToken(this.parser.nextToken(), expected1, expected2);
    }

    public boolean checkCurrentToken(JsonToken expected1, JsonToken expected2) throws IOException {
        return this.checkToken(this.parser.getCurrentToken(), expected1, expected2);
    }

    boolean hasType() throws JsonParseException, IOException {
        JsonToken token = this.parser.nextToken();
        return token == JsonToken.FIELD_NAME && this.parser.getText().equals("$type");
    }

    boolean hasBinary() throws JsonParseException, IOException {
        JsonToken token = this.parser.nextToken();
        return token == JsonToken.FIELD_NAME && this.parser.getText().equals("$binary");
    }

    long getType() throws JsonParseException, IOException {
        if (!this.checkNextToken(JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_STRING)) {
            long type = this.parser.getValueAsLong();
            this.parser.nextToken();
            return type;
        }
        throw new JsonParseException("Failure while reading $type value. Expected a NUMBER or STRING", this.parser.getCurrentLocation());
    }

    public boolean checkToken(JsonToken t, JsonToken expected1, JsonToken expected2) throws IOException {
        if (t == JsonToken.VALUE_NULL) {
            return true;
        }
        if (t == expected1) {
            return false;
        }
        if (t == expected2) {
            return false;
        }
        throw new JsonParseException(String.format("Failure while reading ExtendedJSON typed value. Expected a %s but received a token of type %s", new Object[]{expected1, t}), this.parser.getCurrentLocation());
    }

    public abstract void writeBinary(boolean var1) throws IOException;

    public abstract void writeDate(boolean var1) throws IOException;

    public abstract void writeTime(boolean var1) throws IOException;

    public abstract void writeTimestamp(boolean var1) throws IOException;

    public abstract void writeInterval(boolean var1) throws IOException;

    public abstract void writeInteger(boolean var1) throws IOException;

    public abstract void writeDecimal(boolean var1) throws IOException;

    static class MapVectorOutput
    extends VectorOutput {
        private BaseWriter.MapWriter writer;
        private String fieldName;

        public MapVectorOutput(WorkingBuffer work) {
            super(work);
        }

        public boolean run(BaseWriter.MapWriter writer, String fieldName) throws IOException {
            this.fieldName = fieldName;
            this.writer = writer;
            return this.innerRun();
        }

        @Override
        public void writeBinary(boolean isNull) throws IOException {
            VarBinaryWriter bin = this.writer.varBinary(this.fieldName);
            if (!isNull) {
                long type;
                byte[] binaryData = this.parser.getBinaryValue();
                if (this.hasType() && ((type = this.getType()) < 0L || type > 255L)) {
                    throw UserException.validationError().message("$type should be between 0 to 255", new Object[0]).build(logger);
                }
                this.work.prepareBinary(binaryData, this.binary);
                bin.write(this.binary);
            }
        }

        @Override
        public void writeDate(boolean isNull) throws IOException {
            DateWriter dt = this.writer.date(this.fieldName);
            if (!isNull) {
                LocalDate localDate = LocalDate.parse(this.parser.getValueAsString(), DateUtility.isoFormatDate);
                OffsetDateTime utcDate = OffsetDateTime.of(localDate, LocalTime.MIDNIGHT, ZoneOffset.UTC);
                dt.writeDate(utcDate.toInstant().toEpochMilli());
            }
        }

        @Override
        public void writeTime(boolean isNull) throws IOException {
            TimeWriter t = this.writer.time(this.fieldName);
            if (!isNull) {
                LocalTime localTime = OffsetTime.parse(this.parser.getValueAsString(), DateUtility.isoFormatTime).toLocalTime();
                t.writeTime((int)((localTime.toNanoOfDay() + 500000L) / 1000000L));
            }
        }

        @Override
        public void writeTimestamp(boolean isNull) throws IOException {
            TimeStampWriter ts = this.writer.timeStamp(this.fieldName);
            if (!isNull) {
                switch (this.parser.getCurrentToken()) {
                    case VALUE_NUMBER_INT: {
                        DateTime dt = new DateTime(this.parser.getLongValue(), DateTimeZone.UTC);
                        ts.writeTimeStamp(dt.getMillis());
                        break;
                    }
                    case VALUE_STRING: {
                        OffsetDateTime originalDateTime = OffsetDateTime.parse(this.parser.getValueAsString(), DateUtility.isoFormatTimeStamp);
                        OffsetDateTime utcDateTime = OffsetDateTime.of(originalDateTime.toLocalDateTime(), ZoneOffset.UTC);
                        ts.writeTimeStamp(utcDateTime.toInstant().toEpochMilli());
                        break;
                    }
                    default: {
                        throw UserException.unsupportedError().message(this.parser.getCurrentToken().toString(), new Object[0]).build(logger);
                    }
                }
            }
        }

        @Override
        public void writeInterval(boolean isNull) throws IOException {
            IntervalWriter intervalWriter = this.writer.interval(this.fieldName);
            if (!isNull) {
                Period p = ISOPeriodFormat.standard().parsePeriod(this.parser.getValueAsString());
                int months = DateUtilities.monthsFromPeriod(p);
                int days = p.getDays();
                int millis = DateUtilities.periodToMillis(p);
                intervalWriter.writeInterval(months, days, millis);
            }
        }

        @Override
        public void writeInteger(boolean isNull) throws IOException {
            BigIntWriter intWriter = this.writer.bigInt(this.fieldName);
            if (!isNull) {
                intWriter.writeBigInt(Long.parseLong(this.parser.getValueAsString()));
            }
        }

        @Override
        public void writeDecimal(boolean isNull) throws IOException {
            throw new IOException("Decimal Extended types not yet supported.");
        }
    }

    static class ListVectorOutput
    extends VectorOutput {
        private BaseWriter.ListWriter writer;

        public ListVectorOutput(WorkingBuffer work) {
            super(work);
        }

        public boolean run(BaseWriter.ListWriter writer) throws IOException {
            this.writer = writer;
            return this.innerRun();
        }

        @Override
        public void writeBinary(boolean isNull) throws IOException {
            VarBinaryWriter bin = this.writer.varBinary();
            if (!isNull) {
                long type;
                byte[] binaryData = this.parser.getBinaryValue();
                if (this.hasType() && ((type = this.getType()) < 0L || type > 255L)) {
                    throw UserException.validationError().message("$type should be between 0 to 255", new Object[0]).build(logger);
                }
                this.work.prepareBinary(binaryData, this.binary);
                bin.write(this.binary);
            }
        }

        @Override
        public void writeDate(boolean isNull) throws IOException {
            DateWriter dt = this.writer.date();
            if (!isNull) {
                this.work.prepareVarCharHolder(this.parser.getValueAsString(), this.varchar);
                dt.writeDate(StringFunctionHelpers.getDate((DrillBuf)this.varchar.buffer, (int)this.varchar.start, (int)this.varchar.end));
            }
        }

        @Override
        public void writeTime(boolean isNull) throws IOException {
            TimeWriter t = this.writer.time();
            if (!isNull) {
                LocalTime localTime = OffsetTime.parse(this.parser.getValueAsString(), DateUtility.isoFormatTime).toLocalTime();
                t.writeTime((int)((localTime.toNanoOfDay() + 500000L) / 1000000L));
            }
        }

        @Override
        public void writeTimestamp(boolean isNull) throws IOException {
            TimeStampWriter ts = this.writer.timeStamp();
            if (!isNull) {
                switch (this.parser.getCurrentToken()) {
                    case VALUE_NUMBER_INT: {
                        DateTime dt = new DateTime(this.parser.getLongValue(), DateTimeZone.UTC);
                        ts.writeTimeStamp(dt.getMillis());
                        break;
                    }
                    case VALUE_STRING: {
                        OffsetDateTime originalDateTime = OffsetDateTime.parse(this.parser.getValueAsString(), DateUtility.isoFormatTimeStamp);
                        OffsetDateTime utcDateTime = OffsetDateTime.of(originalDateTime.toLocalDateTime(), ZoneOffset.UTC);
                        ts.writeTimeStamp(utcDateTime.toInstant().toEpochMilli());
                        break;
                    }
                    default: {
                        throw UserException.unsupportedError().message(this.parser.getCurrentToken().toString(), new Object[0]).build(logger);
                    }
                }
            }
        }

        @Override
        public void writeInterval(boolean isNull) throws IOException {
            IntervalWriter intervalWriter = this.writer.interval();
            if (!isNull) {
                Period p = ISOPeriodFormat.standard().parsePeriod(this.parser.getValueAsString());
                int months = DateUtilities.monthsFromPeriod(p);
                int days = p.getDays();
                int millis = DateUtilities.periodToMillis(p);
                intervalWriter.writeInterval(months, days, millis);
            }
        }

        @Override
        public void writeInteger(boolean isNull) throws IOException {
            BigIntWriter intWriter = this.writer.bigInt();
            if (!isNull) {
                intWriter.writeBigInt(Long.parseLong(this.parser.getValueAsString()));
            }
        }

        @Override
        public void writeDecimal(boolean isNull) throws IOException {
            throw new JsonParseException("Decimal Extended types not yet supported.", this.parser.getCurrentLocation());
        }
    }
}

