/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.IntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.IntervalDayVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class IntervalDayWriterImpl
extends AbstractFieldWriter {
    private final IntervalDayVector.Mutator mutator;
    final IntervalDayVector vector;

    public IntervalDayWriterImpl(IntervalDayVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(IntervalDayHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableIntervalDayHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeIntervalDay(int days, int milliseconds) {
        this.mutator.setSafe(this.idx(), days, milliseconds);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

