/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.UInt1Holder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.UInt1Writer;

public class NullableUInt1HolderReaderImpl
extends AbstractFieldReader {
    private NullableUInt1Holder holder;

    public NullableUInt1HolderReaderImpl(NullableUInt1Holder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableUInt1Holder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(UInt1Holder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableUInt1Holder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Byte readByte() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(UInt1Writer writer) {
        if (this.isSet()) {
            writer.writeUInt1(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        UInt1Writer impl = writer.uInt1(name);
        if (this.isSet()) {
            impl.writeUInt1(this.holder.value);
        }
    }
}

