/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathExistsException;
import oadd.org.apache.hadoop.fs.PathIOException;
import oadd.org.apache.hadoop.fs.PathIsNotDirectoryException;
import oadd.org.apache.hadoop.fs.PathNotFoundException;
import oadd.org.apache.hadoop.fs.shell.CommandFactory;
import oadd.org.apache.hadoop.fs.shell.CommandFormat;
import oadd.org.apache.hadoop.fs.shell.FsCommand;
import oadd.org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Mkdir
extends FsCommand {
    public static final String NAME = "mkdir";
    public static final String USAGE = "[-p] <path> ...";
    public static final String DESCRIPTION = "Create a directory in specified location.\n-p: Do not fail if the directory already exists";
    private boolean createParents;

    Mkdir() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Mkdir.class, "-mkdir");
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "p");
        cf.parse(args);
        this.createParents = cf.getOpt("p");
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            if (!this.createParents) {
                throw new PathExistsException(item.toString());
            }
        } else {
            throw new PathIsNotDirectoryException(item.toString());
        }
    }

    @Override
    protected void processNonexistentPath(PathData item) throws IOException {
        Path itemPath;
        Path itemParentPath;
        if (!this.createParents && !item.fs.exists(itemParentPath = (itemPath = new Path(item.path.toString())).getParent())) {
            throw new PathNotFoundException(itemParentPath.toString());
        }
        if (!item.fs.mkdirs(item.path)) {
            throw new PathIOException(item.toString());
        }
    }
}

