/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.commons.lang3.builder.EqualsBuilder;
import oadd.org.apache.commons.lang3.builder.HashCodeBuilder;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ECSchema
implements Serializable {
    private static final long serialVersionUID = 278215328L;
    public static final String NUM_DATA_UNITS_KEY = "numDataUnits";
    public static final String NUM_PARITY_UNITS_KEY = "numParityUnits";
    public static final String CODEC_NAME_KEY = "codec";
    private final String codecName;
    private final int numDataUnits;
    private final int numParityUnits;
    private final Map<String, String> extraOptions;

    public ECSchema(Map<String, String> allOptions) {
        if (allOptions == null || allOptions.isEmpty()) {
            throw new IllegalArgumentException("No schema options are provided");
        }
        this.codecName = allOptions.get(CODEC_NAME_KEY);
        if (this.codecName == null || this.codecName.isEmpty()) {
            throw new IllegalArgumentException("No codec option is provided");
        }
        int tmpNumDataUnits = this.extractIntOption(NUM_DATA_UNITS_KEY, allOptions);
        int tmpNumParityUnits = this.extractIntOption(NUM_PARITY_UNITS_KEY, allOptions);
        if (tmpNumDataUnits < 0 || tmpNumParityUnits < 0) {
            throw new IllegalArgumentException("No good option for numDataUnits or numParityUnits found ");
        }
        this.numDataUnits = tmpNumDataUnits;
        this.numParityUnits = tmpNumParityUnits;
        allOptions.remove(CODEC_NAME_KEY);
        allOptions.remove(NUM_DATA_UNITS_KEY);
        allOptions.remove(NUM_PARITY_UNITS_KEY);
        this.extraOptions = Collections.unmodifiableMap(allOptions);
    }

    public ECSchema(String codecName, int numDataUnits, int numParityUnits) {
        this(codecName, numDataUnits, numParityUnits, null);
    }

    public ECSchema(String codecName, int numDataUnits, int numParityUnits, Map<String, String> extraOptions) {
        assert (codecName != null && !codecName.isEmpty());
        assert (numDataUnits > 0 && numParityUnits > 0);
        this.codecName = codecName;
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
        if (extraOptions == null) {
            extraOptions = new HashMap<String, String>();
        }
        this.extraOptions = Collections.unmodifiableMap(extraOptions);
    }

    private int extractIntOption(String optionKey, Map<String, String> options) {
        int result = -1;
        try {
            if (options.containsKey(optionKey) && (result = Integer.parseInt(options.get(optionKey))) <= 0) {
                throw new IllegalArgumentException("Bad option value " + result + " found for " + optionKey);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Option value " + options.get(optionKey) + " for " + optionKey + " is found. It should be an integer");
        }
        return result;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public Map<String, String> getExtraOptions() {
        return this.extraOptions;
    }

    public int getNumDataUnits() {
        return this.numDataUnits;
    }

    public int getNumParityUnits() {
        return this.numParityUnits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ECSchema=[");
        sb.append("Codec=" + this.codecName + ", ");
        sb.append("numDataUnits=" + this.numDataUnits + ", ");
        sb.append("numParityUnits=" + this.numParityUnits);
        sb.append(this.extraOptions.isEmpty() ? "" : ", ");
        int i = 0;
        for (Map.Entry<String, String> entry : this.extraOptions.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue() + (++i < this.extraOptions.size() ? ", " : ""));
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ECSchema rhs = (ECSchema)o;
        return new EqualsBuilder().append(this.codecName, rhs.codecName).append(this.extraOptions, rhs.extraOptions).append(this.numDataUnits, rhs.numDataUnits).append(this.numParityUnits, rhs.numParityUnits).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1273158869, 1555022101).append(this.codecName).append(this.extraOptions).append(this.numDataUnits).append(this.numParityUnits).toHashCode();
    }
}

