/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.grouper;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.ECBlock;
import oadd.org.apache.hadoop.io.erasurecode.ECBlockGroup;
import oadd.org.apache.hadoop.io.erasurecode.ECSchema;

@InterfaceAudience.Private
public class BlockGrouper {
    private ECSchema schema;

    public void setSchema(ECSchema schema) {
        this.schema = schema;
    }

    protected ECSchema getSchema() {
        return this.schema;
    }

    public int getRequiredNumDataBlocks() {
        return this.schema.getNumDataUnits();
    }

    public int getRequiredNumParityBlocks() {
        return this.schema.getNumParityUnits();
    }

    public ECBlockGroup makeBlockGroup(ECBlock[] dataBlocks, ECBlock[] parityBlocks) {
        ECBlockGroup blockGroup = new ECBlockGroup(dataBlocks, parityBlocks);
        return blockGroup;
    }

    public boolean anyRecoverable(ECBlockGroup blockGroup) {
        int erasedCount = blockGroup.getErasedCount();
        return erasedCount > 0 && erasedCount <= this.getRequiredNumParityBlocks();
    }
}

