/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.AbstractNativeRawDecoder;

@InterfaceAudience.Private
public class NativeRSRawDecoder
extends AbstractNativeRawDecoder {
    public NativeRSRawDecoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
        this.decoderLock.writeLock().lock();
        try {
            this.initImpl(coderOptions.getNumDataUnits(), coderOptions.getNumParityUnits());
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    @Override
    protected void performDecodeImpl(ByteBuffer[] inputs, int[] inputOffsets, int dataLen, int[] erased, ByteBuffer[] outputs, int[] outputOffsets) throws IOException {
        this.decodeImpl(inputs, inputOffsets, dataLen, erased, outputs, outputOffsets);
    }

    @Override
    public void release() {
        this.decoderLock.writeLock().lock();
        try {
            this.destroyImpl();
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return true;
    }

    private native void initImpl(int var1, int var2);

    private native void decodeImpl(ByteBuffer[] var1, int[] var2, int var3, int[] var4, ByteBuffer[] var5, int[] var6) throws IOException;

    private native void destroyImpl();

    static {
        ErasureCodeNative.checkNativeCodeLoaded();
    }
}

