/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.impl;

import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.hadoop.metrics2.AbstractMetric;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;
import oadd.org.apache.hadoop.metrics2.MetricsTag;
import oadd.org.apache.hadoop.metrics2.impl.AbstractMetricsRecord;
import oadd.org.apache.hadoop.metrics2.impl.MsInfo;
import oadd.org.apache.hadoop.metrics2.util.Contracts;

class MetricsRecordImpl
extends AbstractMetricsRecord {
    protected static final String DEFAULT_CONTEXT = "default";
    private final long timestamp;
    private final MetricsInfo info;
    private final List<MetricsTag> tags;
    private final Iterable<AbstractMetric> metrics;

    public MetricsRecordImpl(MetricsInfo info, long timestamp, List<MetricsTag> tags, Iterable<AbstractMetric> metrics) {
        this.timestamp = Contracts.checkArg(timestamp, timestamp > 0L, (Object)"timestamp");
        this.info = Preconditions.checkNotNull(info, "info");
        this.tags = Preconditions.checkNotNull(tags, "tags");
        this.metrics = Preconditions.checkNotNull(metrics, "metrics");
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String name() {
        return this.info.name();
    }

    MetricsInfo info() {
        return this.info;
    }

    @Override
    public String description() {
        return this.info.description();
    }

    @Override
    public String context() {
        for (MetricsTag t : this.tags) {
            if (t.info() != MsInfo.Context) continue;
            return t.value();
        }
        return DEFAULT_CONTEXT;
    }

    public List<MetricsTag> tags() {
        return this.tags;
    }

    @Override
    public Iterable<AbstractMetric> metrics() {
        return this.metrics;
    }
}

