/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.util.ArrayList;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class Progress {
    private static final Logger LOG = LoggerFactory.getLogger(Progress.class);
    private String status = "";
    private float progress;
    private int currentPhase;
    private ArrayList<Progress> phases = new ArrayList();
    private Progress parent;
    private boolean fixedWeightageForAllPhases = false;
    private float progressPerPhase = 0.0f;
    private ArrayList<Float> progressWeightagesForPhases = new ArrayList();

    public Progress addPhase(String status) {
        Progress phase = this.addPhase();
        phase.setStatus(status);
        return phase;
    }

    public synchronized Progress addPhase() {
        Progress phase = this.addNewPhase();
        this.progressPerPhase = 1.0f / (float)this.phases.size();
        this.fixedWeightageForAllPhases = true;
        return phase;
    }

    private synchronized Progress addNewPhase() {
        Progress phase = new Progress();
        this.phases.add(phase);
        phase.setParent(this);
        return phase;
    }

    public Progress addPhase(String status, float weightage) {
        Progress phase = this.addPhase(weightage);
        phase.setStatus(status);
        return phase;
    }

    public synchronized Progress addPhase(float weightage) {
        Progress phase = new Progress();
        this.progressWeightagesForPhases.add(Float.valueOf(weightage));
        this.phases.add(phase);
        phase.setParent(this);
        float sum = 0.0f;
        for (int i = 0; i < this.phases.size(); ++i) {
            sum += this.progressWeightagesForPhases.get(i).floatValue();
        }
        if ((double)sum > 1.0) {
            LOG.warn("Sum of weightages can not be more than 1.0; But sum = " + sum);
        }
        return phase;
    }

    public synchronized void addPhases(int n) {
        for (int i = 0; i < n; ++i) {
            this.addNewPhase();
        }
        this.progressPerPhase = 1.0f / (float)this.phases.size();
        this.fixedWeightageForAllPhases = true;
    }

    float getProgressWeightage(int phaseNum) {
        if (this.fixedWeightageForAllPhases) {
            return this.progressPerPhase;
        }
        return this.progressWeightagesForPhases.get(phaseNum).floatValue();
    }

    synchronized Progress getParent() {
        return this.parent;
    }

    synchronized void setParent(Progress parent) {
        this.parent = parent;
    }

    public synchronized void startNextPhase() {
        ++this.currentPhase;
    }

    public synchronized Progress phase() {
        return this.phases.get(this.currentPhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Progress myParent;
        Progress progress = this;
        synchronized (progress) {
            this.progress = 1.0f;
            myParent = this.parent;
        }
        if (myParent != null) {
            myParent.startNextPhase();
        }
    }

    public synchronized void set(float progress) {
        if (Float.isNaN(progress)) {
            progress = 0.0f;
            LOG.debug("Illegal progress value found, progress is Float.NaN. Progress will be changed to 0");
        } else if (progress == Float.NEGATIVE_INFINITY) {
            progress = 0.0f;
            LOG.debug("Illegal progress value found, progress is Float.NEGATIVE_INFINITY. Progress will be changed to 0");
        } else if (progress < 0.0f) {
            progress = 0.0f;
            LOG.debug("Illegal progress value found, progress is less than 0. Progress will be changed to 0");
        } else if (progress > 1.0f) {
            progress = 1.0f;
            LOG.debug("Illegal progress value found, progress is larger than 1. Progress will be changed to 1");
        } else if (progress == Float.POSITIVE_INFINITY) {
            progress = 1.0f;
            LOG.debug("Illegal progress value found, progress is Float.POSITIVE_INFINITY. Progress will be changed to 1");
        }
        this.progress = progress;
    }

    public synchronized float get() {
        Progress node = this;
        while (node.getParent() != null) {
            node = this.parent;
        }
        return node.getInternal();
    }

    public synchronized float getProgress() {
        return this.getInternal();
    }

    private synchronized float getInternal() {
        int phaseCount = this.phases.size();
        if (phaseCount != 0) {
            float subProgress = 0.0f;
            float progressFromCurrentPhase = 0.0f;
            if (this.currentPhase < phaseCount) {
                subProgress = this.phase().getInternal();
                progressFromCurrentPhase = this.getProgressWeightage(this.currentPhase) * subProgress;
            }
            float progressFromCompletedPhases = 0.0f;
            if (this.fixedWeightageForAllPhases) {
                progressFromCompletedPhases = this.progressPerPhase * (float)this.currentPhase;
            } else {
                for (int i = 0; i < this.currentPhase; ++i) {
                    progressFromCompletedPhases += this.getProgressWeightage(i);
                }
            }
            return progressFromCompletedPhases + progressFromCurrentPhase;
        }
        return this.progress;
    }

    public synchronized void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(result);
        return result.toString();
    }

    private synchronized void toString(StringBuilder buffer) {
        buffer.append(this.status);
        if (this.phases.size() != 0 && this.currentPhase < this.phases.size()) {
            buffer.append(" > ");
            this.phase().toString(buffer);
        }
    }
}

