/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.cli;

import java.util.List;
import oadd.org.apache.commons.cli.CommandLine;
import oadd.org.apache.commons.cli.Options;
import oadd.org.apache.commons.cli.ParseException;
import oadd.org.apache.commons.cli.PosixParser;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.cli.CliCommand;
import oadd.org.apache.zookeeper.cli.CliException;
import oadd.org.apache.zookeeper.cli.CliParseException;
import oadd.org.apache.zookeeper.cli.CliWrapperException;
import oadd.org.apache.zookeeper.cli.MalformedPathException;
import oadd.org.apache.zookeeper.cli.StatPrinter;
import oadd.org.apache.zookeeper.data.Stat;

public class Ls2Command
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public Ls2Command() {
        super("ls2", "path [watch]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<String> children;
        this.err.println("'ls2' has been deprecated. Please use 'ls [-s] path' instead.");
        String path = this.args[1];
        boolean watch = this.args.length > 2;
        Stat stat = new Stat();
        try {
            children = this.zk.getChildren(path, watch, stat);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        this.out.println(children);
        new StatPrinter(this.out).print(stat);
        return watch;
    }
}

