/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.pentaho.aggdes.algorithm.impl;

import oadd.org.pentaho.aggdes.algorithm.Algorithm;
import oadd.org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import oadd.org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import oadd.org.pentaho.aggdes.algorithm.impl.Cost;
import oadd.org.pentaho.aggdes.algorithm.impl.Lattice;
import oadd.org.pentaho.aggdes.algorithm.impl.LatticeImpl;
import oadd.org.pentaho.aggdes.model.Schema;
import oadd.org.pentaho.aggdes.util.BitSetPlus;

class ExhaustiveLatticeImpl
extends LatticeImpl {
    ExhaustiveLatticeImpl(Schema schema) {
        super(schema);
    }

    @Override
    public AggregateImpl chooseAggregate(double maxCost, double minCostBenefitRatio, Cost cost) {
        AggregateImpl bestAggregate = null;
        long max = 1 << this.schema.getAttributes().size();
        double bestBenefit = 0.0;
        int bestBenefitCount = 0;
        int[] benefitCount0 = new int[]{0};
        for (long i = 0L; i < max; ++i) {
            double benefit;
            BitSetPlus bits = this.toBits(i);
            AggregateImpl aggregate = this.getAggregate(bits);
            if (aggregate.materialized || !((benefit = this.getBenefit(aggregate, benefitCount0)) > bestBenefit)) continue;
            bestBenefit = benefit;
            bestAggregate = aggregate;
            bestBenefitCount = benefitCount0[0];
        }
        cost.benefit = bestBenefit;
        cost.benefitCount = bestBenefitCount;
        return bestAggregate;
    }

    @Override
    public Lattice copy() {
        return new ExhaustiveLatticeImpl(this.schema);
    }

    @Override
    public void materialize(AggregateImpl aggregate) {
        super.materialize(aggregate);
        double aggregateCost = aggregate.cost = aggregate.estimateRowCount();
        for (AggregateImpl child : this.nonMaterializedDescendants(aggregate, true)) {
            if (!(aggregateCost < child.cost)) continue;
            child.cost = aggregateCost;
        }
    }

    @Override
    public Algorithm.CostBenefit costBenefitOf(AggregateImpl aggregate) {
        double aggregateCount = Math.pow(2.0, this.schema.getAttributes().size());
        double aggregateCost = aggregate.cost = aggregate.estimateRowCount();
        double costSaving = 0.0;
        for (AggregateImpl child : this.nonMaterializedDescendants(aggregate, true)) {
            if (!(aggregateCost < child.cost)) continue;
            costSaving = child.cost - aggregateCost;
        }
        double costSavingPerQuery = costSaving / aggregateCount;
        return new AlgorithmImpl.CostBenefitImpl(this.schema, aggregate, costSavingPerQuery);
    }
}

