/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.stored.BatchCallableStatementCreatorFactory;
import org.apache.camel.component.sql.stored.CallableStatementWrapperFactory;
import org.apache.camel.component.sql.stored.StatementWrapper;
import org.apache.camel.component.sql.stored.WrapperExecuteCallback;
import org.apache.camel.component.sql.stored.template.ast.InParameter;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;

public class CallableStatementWrapper
implements StatementWrapper {
    final CallableStatementWrapperFactory factory;
    final String template;
    Map result;
    List<Map<String, ?>> batchItems;
    Integer updateCount;
    BatchCallableStatementCreatorFactory batchFactory;

    public CallableStatementWrapper(String template, CallableStatementWrapperFactory wrapperFactory) {
        this.factory = wrapperFactory;
        this.template = template;
    }

    @Override
    public void call(WrapperExecuteCallback cb) throws Exception {
        cb.execute(this);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchItems == null) {
            throw new IllegalArgumentException("Batch must have at least one item");
        }
        final Iterator<Map<String, ?>> params = this.batchItems.iterator();
        return (int[])this.factory.getJdbcTemplate().execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection connection) throws SQLException {
                return CallableStatementWrapper.this.batchFactory.newCallableStatementCreator((Map)params.next()).createCallableStatement(connection);
            }
        }, (CallableStatementCallback)new CallableStatementCallback<int[]>(){

            public int[] doInCallableStatement(CallableStatement callableStatement) throws SQLException, DataAccessException {
                callableStatement.addBatch();
                while (params.hasNext()) {
                    CallableStatementWrapper.this.batchFactory.addParameter(callableStatement, (Map)params.next());
                    callableStatement.addBatch();
                }
                return callableStatement.executeBatch();
            }
        });
    }

    @Override
    public Integer getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public Object executeStatement() throws SQLException {
        return this.result;
    }

    @Override
    public void populateStatement(Object value, Exchange exchange) throws SQLException {
        this.result = this.factory.getTemplateStoredProcedure(this.template).execute(exchange, value);
        this.updateCount = (Integer)this.result.get("#update-count-1");
    }

    @Override
    public void addBatch(Object value, Exchange exchange) {
        if (this.batchFactory == null) {
            this.batchFactory = this.factory.getTemplateForBatch(this.template);
        }
        HashMap<String, Object> batchValues = new HashMap<String, Object>();
        for (Object param : this.batchFactory.getTemplate().getParameterList()) {
            InParameter inputParameter = (InParameter)param;
            Object paramValue = inputParameter.getValueExtractor().eval(exchange, value);
            batchValues.put(inputParameter.getName(), paramValue);
        }
        if (this.batchItems == null) {
            this.batchItems = new ArrayList();
        }
        this.batchItems.add(batchValues);
    }
}

