/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.Exchange;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;

public class ElsqlSqlMapSource
extends AbstractSqlParameterSource {
    private final Exchange exchange;
    private final Map<?, ?> bodyMap;
    private final Map<?, ?> headersMap;

    public ElsqlSqlMapSource(Exchange exchange, Object body) {
        this.exchange = exchange;
        this.bodyMap = ElsqlSqlMapSource.safeMap((Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
        this.headersMap = ElsqlSqlMapSource.safeMap(exchange.getIn().getHeaders());
    }

    private static Map<?, ?> safeMap(Map<?, ?> map) {
        return map == null || map.isEmpty() ? Collections.emptyMap() : map;
    }

    public boolean hasValue(String paramName) {
        if ("body".equals(paramName)) {
            return true;
        }
        if ((paramName.startsWith("$simple{") || paramName.startsWith("${")) && paramName.endsWith("}")) {
            return true;
        }
        return this.bodyMap.containsKey(paramName) || this.headersMap.containsKey(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        Object answer;
        if ("body".equals(paramName)) {
            answer = this.exchange.getIn().getBody();
        } else if ((paramName.startsWith("$simple{") || paramName.startsWith("${")) && paramName.endsWith("}")) {
            paramName = paramName.replace('#', ':');
            answer = this.exchange.getContext().resolveLanguage("simple").createExpression(paramName).evaluate(this.exchange, Object.class);
        } else {
            answer = this.bodyMap.get(paramName);
            if (answer == null) {
                answer = this.headersMap.get(paramName);
            }
        }
        return answer;
    }
}

