/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.processor.aggregate.jdbc.JdbcOptimisticLockingExceptionMapper;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.util.ObjectHelper;
import org.springframework.dao.DataIntegrityViolationException;

public class DefaultJdbcOptimisticLockingExceptionMapper
implements JdbcOptimisticLockingExceptionMapper {
    private final Set<String> classNames = new LinkedHashSet<String>();

    @Override
    public boolean isOptimisticLocking(Exception cause) {
        Iterator it = ObjectHelper.createExceptionIterator((Throwable)cause);
        while (it.hasNext()) {
            SQLException se;
            Throwable throwable = (Throwable)it.next();
            if (throwable instanceof OptimisticLockingAggregationRepository.OptimisticLockingException) {
                return true;
            }
            if (throwable instanceof SQLException && DefaultJdbcOptimisticLockingExceptionMapper.isConstraintViolation(se = (SQLException)throwable)) {
                return true;
            }
            if (throwable instanceof DataIntegrityViolationException) {
                return true;
            }
            String name = throwable.getClass().getName();
            if (!name.contains("ConstraintViolation") && !this.hasClassName(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstraintViolation(SQLException e) {
        return e.getSQLState().startsWith("23");
    }

    private boolean hasClassName(String name) {
        for (String className : this.classNames) {
            if (!className.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addClassName(String name) {
        this.classNames.add(name);
    }

    public void setClassNames(Set<String> names) {
        this.classNames.clear();
        this.classNames.addAll(names);
    }
}

