/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.exec;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelExecSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_EXEC_PATH_EXECUTABLE_CONF = "camel.sink.path.executable";
    public static final String CAMEL_SINK_EXEC_PATH_EXECUTABLE_DOC = "Sets the executable to be executed. The executable must not be empty or null.";
    public static final String CAMEL_SINK_EXEC_PATH_EXECUTABLE_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_ARGS_CONF = "camel.sink.endpoint.args";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_ARGS_DOC = "The arguments may be one or many whitespace-separated tokens.";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_ARGS_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_BINDING_CONF = "camel.sink.endpoint.binding";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_BINDING_DOC = "A reference to a org.apache.commons.exec.ExecBinding in the Registry.";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_BINDING_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_CONF = "camel.sink.endpoint.commandExecutor";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_DOC = "A reference to a org.apache.commons.exec.ExecCommandExecutor in the Registry that customizes the command execution. The default command executor utilizes the commons-exec library, which adds a shutdown hook for every executed command.";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_CONF = "camel.sink.endpoint.commandLogLevel";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_DOC = "Logging level to be used for commands during execution. The default value is DEBUG. Possible values are TRACE, DEBUG, INFO, WARN, ERROR or OFF. (Values of ExecCommandLogLevelType enum) One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_DEFAULT = "DEBUG";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_CONF = "camel.sink.endpoint.outFile";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_DOC = "The name of a file, created by the executable, that should be considered as its output. If no outFile is set, the standard output (stdout) of the executable will be used instead.";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_CONF = "camel.sink.endpoint.timeout";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_DOC = "The timeout, in milliseconds, after which the executable should be terminated. If execution has not completed within the timeout, the component will send a termination request.";
    public static final Long CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_CONF = "camel.sink.endpoint.useStderrOnEmptyStdout";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_DOC = "A boolean indicating that when stdout is empty, this component will populate the Camel Message Body with stderr. This behavior is disabled (false) by default.";
    public static final Boolean CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_DEFAULT = false;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_CONF = "camel.sink.endpoint.workingDir";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_DOC = "The directory in which the command should be executed. If null, the working directory of the current process will be used.";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.exec.lazyStartProducer";
    public static final String CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.exec.basicPropertyBinding";
    public static final String CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelExecSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelExecSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf(Map<String, String> parsedConfig) {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_EXEC_PATH_EXECUTABLE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_PATH_EXECUTABLE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_EXEC_PATH_EXECUTABLE_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_ARGS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_ARGS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_ARGS_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_BINDING_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_BINDING_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_COMMAND_EXECUTOR_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_COMMAND_LOG_LEVEL_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_OUT_FILE_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_USE_STDERR_ON_EMPTY_STDOUT_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_WORKING_DIR_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_EXEC_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}