/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.exec.ExecResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Converter(generateLoader=true)
public final class ExecResultConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExecResultConverter.class);

    private ExecResultConverter() {
    }

    @Converter
    public static InputStream convertToInputStream(ExecResult result) throws FileNotFoundException {
        return ExecResultConverter.toInputStream(result);
    }

    @Converter
    public static byte[] convertToByteArray(ExecResult result, Exchange exchange) throws FileNotFoundException, IOException {
        try (InputStream stream = ExecResultConverter.toInputStream(result);){
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
    }

    @Converter
    public static String convertToString(ExecResult result, Exchange exchange) throws FileNotFoundException {
        InputStream is = ExecResultConverter.toInputStream(result);
        if (is != null) {
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)is);
        }
        return "";
    }

    @Converter
    public static Document convertToDocument(ExecResult result, Exchange exchange) throws FileNotFoundException {
        return ExecResultConverter.convertTo(Document.class, exchange, result);
    }

    private static <T> T convertTo(Class<T> type, Exchange exchange, ExecResult result) throws FileNotFoundException {
        InputStream is = ExecResultConverter.toInputStream(result);
        if (is != null) {
            return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, (Object)is);
        }
        return (T)TypeConverter.MISS_VALUE;
    }

    private static InputStream toInputStream(ExecResult execResult) throws FileNotFoundException {
        InputStream result;
        if (execResult == null) {
            LOG.warn("Received a null ExecResult instance to convert!");
            return null;
        }
        if (execResult.getCommand().getOutFile() != null) {
            result = new FileInputStream(execResult.getCommand().getOutFile());
        } else if (execResult.getStdout() == null && execResult.getCommand().isUseStderrOnEmptyStdout()) {
            LOG.warn("ExecResult has no stdout, will fallback to use stderr.");
            result = execResult.getStderr();
        } else {
            result = execResult.getStdout();
        }
        ExecResultConverter.resetIfByteArrayInputStream(result);
        return result;
    }

    private static void resetIfByteArrayInputStream(InputStream stream) {
        if (stream instanceof ByteArrayInputStream) {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                LOG.error("Unable to reset the stream ", (Throwable)ioe);
            }
        }
    }
}

