/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.file;

import java.util.Map;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CamelFileSourceConnectorConfig
extends CamelSourceConnectorConfig {
    public static final String CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_CONF = "camel.source.path.directoryName";
    public static final String CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_DOC = "The starting directory";
    public static final String CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_CONF = "camel.source.endpoint.charset";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_DOC = "This option is used to specify the encoding of the file. You can use this on the consumer, to specify the encodings of the files, which allow Camel to know the charset it should load the file content in case the file content is being accessed. Likewise when writing a file, you can use this option to specify which charset to write the file as well. Do mind that when writing the file Camel may have to read the message content into memory to be able to convert the data into the configured charset, so do not use this if you have big messages.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_CONF = "camel.source.endpoint.doneFileName";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_DOC = "Producer: If provided, then Camel will write a 2nd done file when the original file has been written. The done file will be empty. This option configures what file name to use. Either you can specify a fixed name. Or you can use dynamic placeholders. The done file will always be written in the same folder as the original file. Consumer: If provided, Camel will only consume files if a done file exists. This option configures what file name to use. Either you can specify a fixed name. Or you can use dynamic placeholders.The done file is always expected in the same folder as the original file. Only ${file.name} and ${file.name.next} is supported as dynamic placeholders.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_CONF = "camel.source.endpoint.fileName";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_DOC = "Use Expression such as File Language to dynamically set the filename. For consumers, it's used as a filename filter. For producers, it's used to evaluate the filename to write. If an expression is set, it take precedence over the CamelFileName header. (Note: The header itself can also be an Expression). The expression options support both String and Expression types. If the expression is a String type, it is always evaluated using the File Language. If the expression is an Expression type, the specified Expression type is used - this allows you, for instance, to use OGNL expressions. For the consumer, you can use it to filter filenames, so you can for instance consume today's file using the File Language syntax: mydata-${date:now:yyyyMMdd}.txt. The producers support the CamelOverruleFileName header which takes precedence over any existing CamelFileName header; the CamelOverruleFileName is a header that is used only once, and makes it easier as this avoids to temporary store CamelFileName and have to restore it afterwards.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DELETE_CONF = "camel.source.endpoint.delete";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DELETE_DOC = "If true, the file will be deleted after it is processed successfully.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_DELETE_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_CONF = "camel.source.endpoint.moveFailed";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_DOC = "Sets the move failure expression based on Simple language. For example, to move files into a .error subdirectory use: .error. Note: When moving the files to the fail location Camel will handle the error and will not pick up the file again.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_NOOP_CONF = "camel.source.endpoint.noop";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_NOOP_DOC = "If true, the file is not moved or deleted in any way. This option is good for readonly data, or for ETL type requirements. If noop=true, Camel will set idempotent=true as well, to avoid consuming the same files over and over again.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_NOOP_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_CONF = "camel.source.endpoint.preMove";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_DOC = "Expression (such as File Language) used to dynamically set the filename when moving it before processing. For example to move in-progress files into the order directory set this value to order.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_CONF = "camel.source.endpoint.preSort";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_DOC = "When pre-sort is enabled then the consumer will sort the file and directory names during polling, that was retrieved from the file system. You may want to do this in case you need to operate on the files in a sorted order. The pre-sort is executed before the consumer starts to filter, and accept files to process by Camel. This option is default=false meaning disabled.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_CONF = "camel.source.endpoint.recursive";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_DOC = "If a directory, will look for files in all the sub-directories as well.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF = "camel.source.endpoint.sendEmptyMessageWhenIdle";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC = "If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_CONF = "camel.source.endpoint.directoryMustExist";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_DOC = "Similar to the startingDirectoryMustExist option but this applies during polling (after starting the consumer).";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_CONF = "camel.source.endpoint.extendedAttributes";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_DOC = "To define which file attributes of interest. Like posix:permissions,posix:owner,basic:lastAccessTime, it supports basic wildcard like posix:, basic:lastAccessTime";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_CONF = "camel.source.endpoint.inProgressRepository";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_DOC = "A pluggable in-progress repository org.apache.camel.spi.IdempotentRepository. The in-progress repository is used to account the current in progress files being consumed. By default a memory based repository is used.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_CONF = "camel.source.endpoint.localWorkDirectory";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_DOC = "When consuming, a local work directory can be used to store the remote file content directly in local files, to avoid loading the content into memory. This is beneficial, if you consume a very big remote file and thus can conserve memory.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.onCompletionExceptionHandler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_DOC = "To use a custom org.apache.camel.spi.ExceptionHandler to handle any thrown exceptions that happens during the file on completion process where the consumer does either a commit or rollback. The default implementation will log any exception at WARN level and ignore.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_CONF = "camel.source.endpoint.pollStrategy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_DOC = "A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_CONF = "camel.source.endpoint.probeContentType";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_DOC = "Whether to enable probing of the content type. If enable then the consumer uses Files#probeContentType(java.nio.file.Path) to determine the content-type of the file, and store that as a header with key Exchange#FILE_CONTENT_TYPE on the Message.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_CONF = "camel.source.endpoint.processStrategy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_DOC = "A pluggable org.apache.camel.component.file.GenericFileProcessStrategy allowing you to implement your own readLock option or similar. Can also be used when special conditions must be met before a file can be consumed, such as a special ready file exists. If this option is set then the readLock option does not apply.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_CONF = "camel.source.endpoint.startingDirectoryMustExist";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_DOC = "Whether the starting directory must exist. Mind that the autoCreate option is default enabled, which means the starting directory is normally auto created if it doesn't exist. You can disable autoCreate and enable this to ensure the starting directory must exist. Will thrown an exception if the directory doesn't exist.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_CONF = "camel.source.endpoint.startingDirectoryMustHaveAccess";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_DOC = "Whether the starting directory has access permissions. Mind that the startingDirectoryMustExist parameter must be set to true in order to verify that the directory exists. Will thrown an exception if the directory doesn't have read and write permissions.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_CONF = "camel.source.endpoint.autoCreate";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_DOC = "Automatically create missing directories in the file's pathname. For the file consumer, that means creating the starting directory. For the file producer, it means the directory the files should be written to.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_CONF = "camel.source.endpoint.bufferSize";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_DOC = "Buffer size in bytes used for writing files (or in case of FTP for downloading and uploading files).";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_DEFAULT = 131072;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_CONF = "camel.source.endpoint.copyAndDeleteOnRenameFail";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_DOC = "Whether to fallback and do a copy and delete file, in case the file could not be renamed directly. This option is not available for the FTP component.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_CONF = "camel.source.endpoint.renameUsingCopy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_DOC = "Perform rename operations using a copy and delete strategy. This is primarily used in environments where the regular rename operation is unreliable (e.g. across different file systems or networks). This option takes precedence over the copyAndDeleteOnRenameFail parameter that will automatically fall back to the copy and delete strategy, but only after additional delays.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_CONF = "camel.source.endpoint.antExclude";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_DOC = "Ant style filter exclusion. If both antInclude and antExclude are used, antExclude takes precedence over antInclude. Multiple exclusions may be specified in comma-delimited format.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_CONF = "camel.source.endpoint.antFilterCaseSensitive";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_DOC = "Sets case sensitive flag on ant filter.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_CONF = "camel.source.endpoint.antInclude";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_DOC = "Ant style filter inclusion. Multiple inclusions may be specified in comma-delimited format.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_CONF = "camel.source.endpoint.eagerMaxMessagesPerPoll";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_DOC = "Allows for controlling whether the limit from maxMessagesPerPoll is eager or not. If eager then the limit is during the scanning of files. Where as false would scan all files, and then perform sorting. Setting this option to false allows for sorting all files first, and then limit the poll. Mind that this requires a higher memory usage as all file details are in memory to perform the sorting.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_CONF = "camel.source.endpoint.exclude";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_DOC = "Is used to exclude files, if filename matches the regex pattern (matching is case in-senstive). Notice if you use symbols such as plus sign and others you would need to configure this using the RAW() syntax if configuring this as an endpoint uri. See more details at configuring endpoint uris";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_CONF = "camel.source.endpoint.filter";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DOC = "Pluggable filter as a org.apache.camel.component.file.GenericFileFilter class. Will skip files if filter returns false in its accept() method.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_CONF = "camel.source.endpoint.filterDirectory";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_DOC = "Filters the directory based on Simple language. For example to filter on current date, you can use a simple date pattern such as ${date:now:yyyMMdd}";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_CONF = "camel.source.endpoint.filterFile";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_DOC = "Filters the file based on Simple language. For example to filter on file size, you can use ${file:size} 5000";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_CONF = "camel.source.endpoint.idempotent";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_DOC = "Option to use the Idempotent Consumer EIP pattern to let Camel skip already processed files. Will by default use a memory based LRUCache that holds 1000 entries. If noop=true then idempotent will be enabled as well to avoid consuming the same files over and over again.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_DEFAULT = "false";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_CONF = "camel.source.endpoint.idempotentKey";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_DOC = "To use a custom idempotent key. By default the absolute path of the file is used. You can use the File Language, for example to use the file name and file size, you can do: idempotentKey=${file:name}-${file:size}";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_CONF = "camel.source.endpoint.idempotentRepository";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_DOC = "A pluggable repository org.apache.camel.spi.IdempotentRepository which by default use MemoryMessageIdRepository if none is specified and idempotent is true.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_CONF = "camel.source.endpoint.include";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_DOC = "Is used to include files, if filename matches the regex pattern (matching is case in-sensitive). Notice if you use symbols such as plus sign and others you would need to configure this using the RAW() syntax if configuring this as an endpoint uri. See more details at configuring endpoint uris";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_CONF = "camel.source.endpoint.maxDepth";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_DOC = "The maximum depth to traverse when recursively processing a directory.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_DEFAULT = Integer.MAX_VALUE;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_CONF = "camel.source.endpoint.maxMessagesPerPoll";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_DOC = "To define a maximum messages to gather per poll. By default no maximum is set. Can be used to set a limit of e.g. 1000 to avoid when starting up the server that there are thousands of files. Set a value of 0 or negative to disabled it. Notice: If this option is in use then the File and FTP components will limit before any sorting. For example if you have 100000 files and use maxMessagesPerPoll=500, then only the first 500 files will be picked up, and then sorted. You can use the eagerMaxMessagesPerPoll option and set this to false to allow to scan all files first and then sort afterwards.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_CONF = "camel.source.endpoint.minDepth";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_DOC = "The minimum depth to start processing when recursively processing a directory. Using minDepth=1 means the base directory. Using minDepth=2 means the first sub directory.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_CONF = "camel.source.endpoint.move";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_DOC = "Expression (such as Simple Language) used to dynamically set the filename when moving it after processing. To move files into a .done subdirectory just enter .done.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_MOVE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_CONF = "camel.source.endpoint.exclusiveReadLockStrategy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_DOC = "Pluggable read-lock as a org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy implementation.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CONF = "camel.source.endpoint.readLock";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DOC = "Used by consumer, to only poll the files if it has exclusive read-lock on the file (i.e. the file is not in-progress or being written). Camel will wait until the file lock is granted. This option provides the build in strategies: - none - No read lock is in use - markerFile - Camel creates a marker file (fileName.camelLock) and then holds a lock on it. This option is not available for the FTP component - changed - Changed is using file length/modification timestamp to detect whether the file is currently being copied or not. Will at least use 1 sec to determine this, so this option cannot consume files as fast as the others, but can be more reliable as the JDK IO API cannot always determine whether a file is currently being used by another process. The option readLockCheckInterval can be used to set the check frequency. - fileLock - is for using java.nio.channels.FileLock. This option is not avail for Windows OS and the FTP component. This approach should be avoided when accessing a remote file system via a mount/share unless that file system supports distributed file locks. - rename - rename is for using a try to rename the file as a test if we can get exclusive read-lock. - idempotent - (only for file component) idempotent is for using a idempotentRepository as the read-lock. This allows to use read locks that supports clustering if the idempotent repository implementation supports that. - idempotent-changed - (only for file component) idempotent-changed is for using a idempotentRepository and changed as the combined read-lock. This allows to use read locks that supports clustering if the idempotent repository implementation supports that. - idempotent-rename - (only for file component) idempotent-rename is for using a idempotentRepository and rename as the combined read-lock. This allows to use read locks that supports clustering if the idempotent repository implementation supports that.Notice: The various read locks is not all suited to work in clustered mode, where concurrent consumers on different nodes is competing for the same files on a shared file system. The markerFile using a close to atomic operation to create the empty marker file, but its not guaranteed to work in a cluster. The fileLock may work better but then the file system need to support distributed file locks, and so on. Using the idempotent read lock can support clustering if the idempotent repository supports clustering, such as Hazelcast Component or Infinispan. One of: [none] [markerFile] [fileLock] [rename] [changed] [idempotent] [idempotent-changed] [idempotent-rename]";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DEFAULT = "none";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_CONF = "camel.source.endpoint.readLockCheckInterval";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_DOC = "Interval in millis for the read-lock, if supported by the read lock. This interval is used for sleeping between attempts to acquire the read lock. For example when using the changed read lock, you can set a higher interval period to cater for slow writes. The default of 1 sec. may be too fast if the producer is very slow writing the file. Notice: For FTP the default readLockCheckInterval is 5000. The readLockTimeout value must be higher than readLockCheckInterval, but a rule of thumb is to have a timeout that is at least 2 or more times higher than the readLockCheckInterval. This is needed to ensure that amble time is allowed for the read lock process to try to grab the lock before the timeout was hit.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_CONF = "camel.source.endpoint.readLockDeleteOrphanLockFiles";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_DOC = "Whether or not read lock with marker files should upon startup delete any orphan read lock files, which may have been left on the file system, if Camel was not properly shutdown (such as a JVM crash). If turning this option to false then any orphaned lock file will cause Camel to not attempt to pickup that file, this could also be due another node is concurrently reading files from the same shared directory.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_CONF = "camel.source.endpoint.readLockIdempotentReleaseAsync";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_DOC = "Whether the delayed release task should be synchronous or asynchronous. See more details at the readLockIdempotentReleaseDelay option.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_CONF = "camel.source.endpoint.readLockIdempotentReleaseAsyncPoolSize";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_DOC = "The number of threads in the scheduled thread pool when using asynchronous release tasks. Using a default of 1 core threads should be sufficient in almost all use-cases, only set this to a higher value if either updating the idempotent repository is slow, or there are a lot of files to process. This option is not in-use if you use a shared thread pool by configuring the readLockIdempotentReleaseExecutorService option. See more details at the readLockIdempotentReleaseDelay option.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_CONF = "camel.source.endpoint.readLockIdempotentReleaseDelay";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_DOC = "Whether to delay the release task for a period of millis. This can be used to delay the release tasks to expand the window when a file is regarded as read-locked, in an active/active cluster scenario with a shared idempotent repository, to ensure other nodes cannot potentially scan and acquire the same file, due to race-conditions. By expanding the time-window of the release tasks helps prevents these situations. Note delaying is only needed if you have configured readLockRemoveOnCommit to true.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.readLockIdempotentReleaseExecutorService";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_DOC = "To use a custom and shared thread pool for asynchronous release tasks. See more details at the readLockIdempotentReleaseDelay option.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_CONF = "camel.source.endpoint.readLockLoggingLevel";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_DOC = "Logging level used when a read lock could not be acquired. By default a DEBUG is logged. You can change this level, for example to OFF to not have any logging. This option is only applicable for readLock of types: changed, fileLock, idempotent, idempotent-changed, idempotent-rename, rename. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_DEFAULT = "DEBUG";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_CONF = "camel.source.endpoint.readLockMarkerFile";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_DOC = "Whether to use marker file with the changed, rename, or exclusive read lock types. By default a marker file is used as well to guard against other processes picking up the same files. This behavior can be turned off by setting this option to false. For example if you do not want to write marker files to the file systems by the Camel application.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_CONF = "camel.source.endpoint.readLockMinAge";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_DOC = "This option is applied only for readLock=changed. It allows to specify a minimum age the file must be before attempting to acquire the read lock. For example use readLockMinAge=300s to require the file is at last 5 minutes old. This can speedup the changed read lock as it will only attempt to acquire files which are at least that given age.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_CONF = "camel.source.endpoint.readLockMinLength";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_DOC = "This option is applied only for readLock=changed. It allows you to configure a minimum file length. By default Camel expects the file to contain data, and thus the default value is 1. You can set this option to zero, to allow consuming zero-length files.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_DEFAULT = 1L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_CONF = "camel.source.endpoint.readLockRemoveOnCommit";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_DOC = "This option is applied only for readLock=idempotent. It allows to specify whether to remove the file name entry from the idempotent repository when processing the file is succeeded and a commit happens. By default the file is not removed which ensures that any race-condition do not occur so another active node may attempt to grab the file. Instead the idempotent repository may support eviction strategies that you can configure to evict the file name entry after X minutes - this ensures no problems with race conditions. See more details at the readLockIdempotentReleaseDelay option.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_CONF = "camel.source.endpoint.readLockRemoveOnRollback";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_DOC = "This option is applied only for readLock=idempotent. It allows to specify whether to remove the file name entry from the idempotent repository when processing the file failed and a rollback happens. If this option is false, then the file name entry is confirmed (as if the file did a commit).";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_CONF = "camel.source.endpoint.readLockTimeout";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_DOC = "Optional timeout in millis for the read-lock, if supported by the read-lock. If the read-lock could not be granted and the timeout triggered, then Camel will skip the file. At next poll Camel, will try the file again, and this time maybe the read-lock could be granted. Use a value of 0 or lower to indicate forever. Currently fileLock, changed and rename support the timeout. Notice: For FTP the default readLockTimeout value is 20000 instead of 10000. The readLockTimeout value must be higher than readLockCheckInterval, but a rule of thumb is to have a timeout that is at least 2 or more times higher than the readLockCheckInterval. This is needed to ensure that amble time is allowed for the read lock process to try to grab the lock before the timeout was hit.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF = "camel.source.endpoint.backoffErrorThreshold";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC = "The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF = "camel.source.endpoint.backoffIdleThreshold";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC = "The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_CONF = "camel.source.endpoint.backoffMultiplier";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_DOC = "To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.";
    public static final Integer CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_DELAY_DOC = "Milliseconds before the next poll.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_DELAY_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_CONF = "camel.source.endpoint.greedy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_DOC = "If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_DOC = "Milliseconds before the first poll starts.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_CONF = "camel.source.endpoint.repeatCount";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_DOC = "Specifies a maximum limit of number of fires. So if you set it to 1, the scheduler will only fire once. If you set it to 5, it will only fire five times. A value of zero or negative means fire forever.";
    public static final Long CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_CONF = "camel.source.endpoint.runLoggingLevel";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_DOC = "The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT = "TRACE";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.scheduledExecutorService";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC = "Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_CONF = "camel.source.endpoint.scheduler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_DOC = "To use a cron scheduler from either camel-spring or camel-quartz component. Use value spring or quartz for built in scheduler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_DEFAULT = "none";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_CONF = "camel.source.endpoint.schedulerProperties";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_DOC = "To configure additional properties when using a custom scheduler or any of the Quartz, Spring based scheduler.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_CONF = "camel.source.endpoint.startScheduler";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_DOC = "Whether the scheduler should be auto started.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_CONF = "camel.source.endpoint.timeUnit";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_DOC = "Time unit for initialDelay and delay options. One of: [NANOSECONDS] [MICROSECONDS] [MILLISECONDS] [SECONDS] [MINUTES] [HOURS] [DAYS]";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_DEFAULT = "MILLISECONDS";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_CONF = "camel.source.endpoint.useFixedDelay";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_DOC = "Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_CONF = "camel.source.endpoint.shuffle";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_DOC = "To shuffle the list of files (sort in random order)";
    public static final Boolean CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_CONF = "camel.source.endpoint.sortBy";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_DOC = "Built-in sort by using the File Language. Supports nested sorts, so you can have a sort by file name and as a 2nd group sort by modified date.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORTER_CONF = "camel.source.endpoint.sorter";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORTER_DOC = "Pluggable sorter as a java.util.Comparator class.";
    public static final String CAMEL_SOURCE_FILE_ENDPOINT_SORTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FILE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.file.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_FILE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_FILE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.file.basicPropertyBinding";
    public static final String CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelFileSourceConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelFileSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(CamelFileSourceConnectorConfig.conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_FILE_PATH_DIRECTORY_NAME_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_CHARSET_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_DONE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.");
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_DELETE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_DELETE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_MOVE_FAILED_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_NOOP_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_NOOP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_NOOP_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_PRE_MOVE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_PRE_SORT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_RECURSIVE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_DIRECTORY_MUST_EXIST_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EXTENDED_ATTRIBUTES_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_IN_PROGRESS_REPOSITORY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_LOCAL_WORK_DIRECTORY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_ON_COMPLETION_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_POLL_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_PROBE_CONTENT_TYPE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_PROCESS_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_EXIST_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_STARTING_DIRECTORY_MUST_HAVE_ACCESS_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_AUTO_CREATE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_BUFFER_SIZE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_COPY_AND_DELETE_ON_RENAME_FAIL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_RENAME_USING_COPY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_ANT_EXCLUDE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_ANT_FILTER_CASE_SENSITIVE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_ANT_INCLUDE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EAGER_MAX_MESSAGES_PER_POLL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EXCLUDE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_FILTER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_FILTER_DIRECTORY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_FILTER_FILE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_KEY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_IDEMPOTENT_REPOSITORY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_INCLUDE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_MAX_DEPTH_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_MAX_MESSAGES_PER_POLL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_MIN_DEPTH_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_MOVE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_MOVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_MOVE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_EXCLUSIVE_READ_LOCK_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CONF, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_CHECK_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_DELETE_ORPHAN_LOCK_FILES_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_ASYNC_POOL_SIZE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_DELAY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_IDEMPOTENT_RELEASE_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MARKER_FILE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_AGE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_MIN_LENGTH_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_COMMIT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_REMOVE_ON_ROLLBACK_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_READ_LOCK_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_CONF, ConfigDef.Type.INT, (Object)CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_BACKOFF_MULTIPLIER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_GREEDY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_REPEAT_COUNT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_RUN_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_CONF, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SCHEDULER_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_START_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_TIME_UNIT_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_USE_FIXED_DELAY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SHUFFLE_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SORT_BY_DOC);
        conf.define(CAMEL_SOURCE_FILE_ENDPOINT_SORTER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_FILE_ENDPOINT_SORTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FILE_ENDPOINT_SORTER_DOC);
        conf.define(CAMEL_SOURCE_FILE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.");
        conf.define(CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_FILE_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}

