/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.file.transformers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms File to String");
    private static final Logger LOG = LoggerFactory.getLogger(FileTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (r.value() instanceof GenericFile) {
            LOG.debug("Converting record from RemoteFile to text");
            GenericFile message = (GenericFile)r.value();
            String c = null;
            try {
                c = FileUtils.readFileToString((File)((File)message.getFile()), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)c), (Object)c, r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", r.value().getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

