/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@Internal
public class PojoCsvInputFormat<OUT>
extends CsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    private Class<OUT> pojoTypeClass;
    private String[] pojoFieldNames;
    private transient PojoTypeInfo<OUT> pojoTypeInfo;
    private transient Field[] pojoFields;

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo) {
        this(filePath, "\n", ",", pojoTypeInfo);
    }

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames) {
        this(filePath, "\n", ",", pojoTypeInfo, fieldNames, PojoCsvInputFormat.createDefaultMask(pojoTypeInfo.getArity()));
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo) {
        this(filePath, lineDelimiter, fieldDelimiter, pojoTypeInfo, pojoTypeInfo.getFieldNames(), PojoCsvInputFormat.createDefaultMask(pojoTypeInfo.getArity()));
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames) {
        this(filePath, lineDelimiter, fieldDelimiter, pojoTypeInfo, fieldNames, PojoCsvInputFormat.createDefaultMask(fieldNames.length));
    }

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, int[] includedFieldsMask) {
        this(filePath, "\n", ",", pojoTypeInfo, pojoTypeInfo.getFieldNames(), PojoCsvInputFormat.toBooleanMask(includedFieldsMask));
    }

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, int[] includedFieldsMask) {
        this(filePath, "\n", ",", pojoTypeInfo, fieldNames, includedFieldsMask);
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, int[] includedFieldsMask) {
        this(filePath, lineDelimiter, fieldDelimiter, pojoTypeInfo, pojoTypeInfo.getFieldNames(), includedFieldsMask);
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, int[] includedFieldsMask) {
        super(filePath);
        boolean[] mask = includedFieldsMask == null ? PojoCsvInputFormat.createDefaultMask(fieldNames.length) : PojoCsvInputFormat.toBooleanMask(includedFieldsMask);
        this.configure(lineDelimiter, fieldDelimiter, pojoTypeInfo, fieldNames, mask);
    }

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, boolean[] includedFieldsMask) {
        this(filePath, "\n", ",", pojoTypeInfo, pojoTypeInfo.getFieldNames(), includedFieldsMask);
    }

    public PojoCsvInputFormat(Path filePath, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, boolean[] includedFieldsMask) {
        this(filePath, "\n", ",", pojoTypeInfo, fieldNames, includedFieldsMask);
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, boolean[] includedFieldsMask) {
        this(filePath, lineDelimiter, fieldDelimiter, pojoTypeInfo, pojoTypeInfo.getFieldNames(), includedFieldsMask);
    }

    public PojoCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, boolean[] includedFieldsMask) {
        super(filePath);
        this.configure(lineDelimiter, fieldDelimiter, pojoTypeInfo, fieldNames, includedFieldsMask);
    }

    private void configure(String lineDelimiter, String fieldDelimiter, PojoTypeInfo<OUT> pojoTypeInfo, String[] fieldNames, boolean[] includedFieldsMask) {
        if (includedFieldsMask == null) {
            includedFieldsMask = PojoCsvInputFormat.createDefaultMask(fieldNames.length);
        }
        for (String name : fieldNames) {
            if (name == null) {
                throw new NullPointerException("Field name must not be null.");
            }
            if (pojoTypeInfo.getFieldIndex(name) >= 0) continue;
            throw new IllegalArgumentException("Field \"" + name + "\" not part of POJO type " + pojoTypeInfo.getTypeClass().getCanonicalName());
        }
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        Class[] classes = new Class[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            try {
                classes[i] = pojoTypeInfo.getTypeAt(pojoTypeInfo.getFieldIndex(fieldNames[i])).getTypeClass();
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid field name: " + fieldNames[i]);
            }
        }
        this.pojoTypeClass = pojoTypeInfo.getTypeClass();
        this.pojoTypeInfo = pojoTypeInfo;
        this.setFieldsGeneric(includedFieldsMask, classes);
        this.setOrderOfPOJOFields(fieldNames);
    }

    private void setOrderOfPOJOFields(String[] fieldNames) {
        Preconditions.checkNotNull((Object)fieldNames);
        int includedCount = 0;
        for (boolean isIncluded : this.fieldIncluded) {
            if (!isIncluded) continue;
            ++includedCount;
        }
        Preconditions.checkArgument((includedCount == fieldNames.length ? 1 : 0) != 0, (Object)(includedCount + " CSV fields and " + fieldNames.length + " POJO fields selected. The number of selected CSV and POJO fields must be equal."));
        for (String field : fieldNames) {
            Preconditions.checkNotNull((Object)field, (String)"The field name cannot be null.");
            Preconditions.checkArgument((this.pojoTypeInfo.getFieldIndex(field) != -1 ? 1 : 0) != 0, (Object)("Field \"" + field + "\" is not a member of POJO class " + this.pojoTypeClass.getName()));
        }
        this.pojoFieldNames = Arrays.copyOfRange(fieldNames, 0, fieldNames.length);
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.pojoFields = new Field[this.pojoFieldNames.length];
        HashMap<String, Field> allFields = new HashMap<String, Field>();
        this.findAllFields(this.pojoTypeClass, allFields);
        for (int i = 0; i < this.pojoFieldNames.length; ++i) {
            this.pojoFields[i] = (Field)allFields.get(this.pojoFieldNames[i]);
            if (this.pojoFields[i] == null) {
                throw new RuntimeException("There is no field called \"" + this.pojoFieldNames[i] + "\" in " + this.pojoTypeClass.getName());
            }
            this.pojoFields[i].setAccessible(true);
        }
    }

    private void findAllFields(Class<?> clazz, Map<String, Field> allFields) {
        for (Field field : clazz.getDeclaredFields()) {
            allFields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            this.findAllFields(clazz.getSuperclass(), allFields);
        }
    }

    @Override
    public OUT fillRecord(OUT reuse, Object[] parsedValues) {
        for (int i = 0; i < parsedValues.length; ++i) {
            try {
                this.pojoFields[i].set(reuse, parsedValues[i]);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Parsed value could not be set in POJO field \"" + this.pojoFieldNames[i] + "\"", e);
            }
        }
        return reuse;
    }
}

